/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class FailoverUpdateURIsTest
extends TestCase {
    private static final String QUEUE_NAME = "test.failoverupdateuris";

    public void testUpdateURIs() throws Exception {
        long timeout = 1000L;
        URI firstTcpUri = new URI("tcp://localhost:61616");
        URI secondTcpUri = new URI("tcp://localhost:61626");
        String targetDir = "target/" + this.getName();
        new File(targetDir).mkdir();
        File updateFile = new File(targetDir + "/updateURIsFile.txt");
        System.out.println(updateFile);
        System.out.println(updateFile.toURI());
        System.out.println(updateFile.getAbsoluteFile());
        System.out.println(updateFile.getAbsoluteFile().toURI());
        FileOutputStream out = new FileOutputStream(updateFile);
        out.write(firstTcpUri.toString().getBytes());
        out.close();
        BrokerService bs1 = new BrokerService();
        bs1.setUseJmx(false);
        bs1.addConnector(firstTcpUri);
        bs1.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:()?updateURIsURL=file:///" + updateFile.getAbsoluteFile());
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue theQueue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)theQueue);
        MessageConsumer consumer = session.createConsumer((Destination)theQueue);
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        Message msg = consumer.receive(2000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
        bs1.stop();
        bs1.waitUntilStopped();
        BrokerService bs2 = new BrokerService();
        bs2.setUseJmx(false);
        bs2.addConnector(secondTcpUri);
        bs2.start();
        out = new FileOutputStream(updateFile, true);
        out.write(",".getBytes());
        out.write(secondTcpUri.toString().getBytes());
        out.close();
        producer.send((Message)message);
        msg = consumer.receive(2000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
    }
}

