/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompSubscriptionRemoveTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(StompSubscriptionRemoveTest.class);
    private static final String COMMAND_MESSAGE = "MESSAGE";
    private static final String HEADER_MESSAGE_ID = "message-id";
    private static final int STOMP_PORT = 61613;
    private StompConnection stompConnection = new StompConnection();

    public void testRemoveSubscriber() throws Exception {
        String ackmessage;
        String messageId;
        String receiveFrame;
        int count;
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.addConnector("stomp://localhost:61613").setName("Stomp");
        broker.addConnector("tcp://localhost:61616").setName("Default");
        broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(this.getDestinationName()));
        TextMessage message = session.createTextMessage("Testas");
        for (int idx = 0; idx < 2000; ++idx) {
            producer.send((Message)message);
            LOG.debug((Object)("Sending: " + idx));
        }
        producer.close();
        session.close();
        connection.close();
        this.stompConnection.open(new Socket("localhost", 61613));
        String connectFrame = "CONNECT\nlogin: brianm\npasscode: wombats\n\n";
        this.stompConnection.sendFrame(connectFrame);
        this.stompConnection.receiveFrame();
        String frame = "SUBSCRIBE\ndestination:/queue/" + this.getDestinationName() + "\n" + "ack:client\n\n";
        this.stompConnection.sendFrame(frame);
        int messagesCount = 0;
        for (count = 0; count < 2; ++count) {
            receiveFrame = this.stompConnection.receiveFrame();
            LOG.debug((Object)("Received: " + receiveFrame));
            StompSubscriptionRemoveTest.assertEquals((String)"Unexpected frame received", (String)COMMAND_MESSAGE, (String)this.getCommand(receiveFrame));
            messageId = this.getHeaderValue(receiveFrame, HEADER_MESSAGE_ID);
            ackmessage = "ACK\nmessage-id:" + messageId + "\n\n";
            this.stompConnection.sendFrame(ackmessage);
            ++messagesCount;
        }
        this.stompConnection.sendFrame("DISCONNECT\n\n");
        Thread.sleep(1000L);
        this.stompConnection.close();
        this.stompConnection.open(new Socket("localhost", 61613));
        connectFrame = "CONNECT\nlogin: brianm\npasscode: wombats\n\n";
        this.stompConnection.sendFrame(connectFrame);
        this.stompConnection.receiveFrame();
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getDestinationName() + "\n" + "ack:client\n\n";
        this.stompConnection.sendFrame(frame);
        try {
            while (count != 2000) {
                receiveFrame = this.stompConnection.receiveFrame();
                LOG.debug((Object)("Received: " + receiveFrame));
                StompSubscriptionRemoveTest.assertEquals((String)"Unexpected frame received", (String)COMMAND_MESSAGE, (String)this.getCommand(receiveFrame));
                messageId = this.getHeaderValue(receiveFrame, HEADER_MESSAGE_ID);
                ackmessage = "ACK\nmessage-id:" + messageId.trim() + "\n\n";
                this.stompConnection.sendFrame(ackmessage);
                ++messagesCount;
                ++count;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.stompConnection.sendFrame("DISCONNECT\n\n");
        this.stompConnection.close();
        broker.stop();
        LOG.info((Object)("Total messages received: " + messagesCount));
        StompSubscriptionRemoveTest.assertTrue((String)("Messages received after connection loss: " + messagesCount), (messagesCount >= 2000 ? 1 : 0) != 0);
    }

    protected String getDestinationName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected String getCommand(String frame) {
        return frame.substring(0, frame.indexOf(10) + 1).trim();
    }

    protected String getHeaderValue(String frame, String header) throws IOException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(frame.getBytes()));
        int idx = 0;
        String line;
        while ((line = input.readLine()) != null) {
            int pos;
            if ((line = line.trim()).length() == 0) {
                return null;
            }
            if (idx > 0 && header.equals(line.substring(0, pos = line.indexOf(58)))) {
                return line.substring(pos + 1).trim();
            }
            ++idx;
        }
        return null;
    }
}

