/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.stomp.SamplePojo;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(StompTest.class);
    protected String bindAddress = "stomp://localhost:61613";
    protected String confUri = "xbean:org/apache/activemq/transport/stomp/stomp-auth-broker.xml";
    protected String jmsUri = "vm://localhost";
    private BrokerService broker;
    private StompConnection stompConnection = new StompConnection();
    private Connection connection;
    private Session session;
    private ActiveMQQueue queue;
    private final String xmlObject = "<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>";
    private String xmlMap = "<map>\n  <entry>\n    <string>name</string>\n    <string>Dejan</string>\n  </entry>\n  <entry>\n    <string>city</string>\n    <string>Belgrade</string>\n  </entry>\n</map>\n";
    private final String jsonObject = "{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}";
    private String jsonMap = "{\"map\":{\"entry\":[{\"string\":[\"name\",\"Dejan\"]},{\"string\":[\"city\",\"Belgrade\"]}]}}";

    protected void setUp() throws Exception {
        if (System.getProperty("java.vendor").equals("IBM Corporation") && System.getProperty("java.version").startsWith("1.5")) {
            this.xmlMap = "<map>\n  <entry>\n    <string>city</string>\n    <string>Belgrade</string>\n  </entry>\n  <entry>\n    <string>name</string>\n    <string>Dejan</string>\n  </entry>\n</map>\n";
            this.jsonMap = "{\"map\":{\"entry\":[{\"string\":[\"city\",\"Belgrade\"]},{\"string\":[\"name\",\"Dejan\"]}]}}";
        }
        this.broker = BrokerFactory.createBroker((URI)new URI(this.confUri));
        this.broker.start();
        this.stompConnect();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.jmsUri);
        this.connection = cf.createConnection("system", "manager");
        this.session = this.connection.createSession(false, 1);
        this.queue = new ActiveMQQueue(this.getQueueName());
        this.connection.start();
    }

    private void stompConnect() throws IOException, URISyntaxException, UnknownHostException {
        URI connectUri = new URI(this.bindAddress);
        this.stompConnection.open(this.createSocket(connectUri));
    }

    protected Socket createSocket(URI connectUri) throws IOException {
        return new Socket("127.0.0.1", connectUri.getPort());
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.connection.close();
            this.stompDisconnect();
        }
        catch (Exception exception) {
        }
        finally {
            this.broker.stop();
        }
    }

    private void stompDisconnect() throws IOException {
        if (this.stompConnection != null) {
            this.stompConnection.close();
            this.stompConnection = null;
        }
    }

    public void sendMessage(String msg) throws Exception {
        this.sendMessage(msg, "foo", "xyz");
    }

    public void sendMessage(String msg, String propertyName, String propertyValue) throws JMSException {
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        TextMessage message = this.session.createTextMessage(msg);
        message.setStringProperty(propertyName, propertyValue);
        producer.send((Message)message);
    }

    public void sendBytesMessage(byte[] msg) throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        BytesMessage message = this.session.createBytesMessage();
        message.writeBytes(msg);
        producer.send((Message)message);
    }

    public void testConnect() throws Exception {
        String connectFrame = "CONNECT\nlogin: system\npasscode: manager\nrequest-id: 1\n\n\u0000";
        this.stompConnection.sendFrame(connectFrame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        StompTest.assertTrue((f.indexOf("response-id:1") >= 0 ? 1 : 0) != 0);
    }

    public void testSendMessage() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        StompTest.assertTrue((Math.abs(tnow - tmsg) < 1000L ? 1 : 0) != 0);
    }

    public void testJMSXGroupIdCanBeSet() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "JMSXGroupID: TEST\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"TEST", (String)((ActiveMQTextMessage)message).getGroupID());
    }

    public void testSendMessageWithCustomHeadersAndSelector() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue, "foo = 'abc'");
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\nfoo:abc\nbar:123\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        StompTest.assertEquals((String)"foo", (String)"abc", (String)message.getStringProperty("foo"));
        StompTest.assertEquals((String)"bar", (String)"123", (String)message.getStringProperty("bar"));
    }

    public void testSendMessageWithDelay() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\nAMQ_SCHEDULED_DELAY:5000\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2000L);
        StompTest.assertNull((Object)message);
        message = (TextMessage)consumer.receive(5000L);
        StompTest.assertNotNull((Object)message);
    }

    public void testSendMessageWithStandardHeaders() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ncorrelation-id:c123\npriority:3\ntype:t345\nJMSXGroupID:abc\nfoo:abc\nbar:123\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        StompTest.assertEquals((String)"JMSCorrelationID", (String)"c123", (String)message.getJMSCorrelationID());
        StompTest.assertEquals((String)"getJMSType", (String)"t345", (String)message.getJMSType());
        StompTest.assertEquals((String)"getJMSPriority", (int)3, (int)message.getJMSPriority());
        StompTest.assertEquals((String)"foo", (String)"abc", (String)message.getStringProperty("foo"));
        StompTest.assertEquals((String)"bar", (String)"123", (String)message.getStringProperty("bar"));
        StompTest.assertEquals((String)"JMSXGroupID", (String)"abc", (String)message.getStringProperty("JMSXGroupID"));
        ActiveMQTextMessage amqMessage = (ActiveMQTextMessage)message;
        StompTest.assertEquals((String)"GroupID", (String)"abc", (String)amqMessage.getGroupID());
    }

    public void testReceipts() throws Exception {
        StompConnection receiver = new StompConnection();
        URI connectUri = new URI(this.bindAddress);
        receiver.open(this.createSocket(connectUri));
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        receiver.sendFrame(frame);
        frame = receiver.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        receiver.sendFrame(frame);
        frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "receipt: msg-1\n" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = receiver.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        StompTest.assertTrue((String)"Stomp Message does not contain receipt request", (frame.indexOf("receipt") == -1 ? 1 : 0) != 0);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("RECEIPT"));
        StompTest.assertTrue((String)"Receipt contains correct receipt-id", (frame.indexOf("receipt-id") >= 0 ? 1 : 0) != 0);
        frame = "DISCONNECT\n\n\n\u0000";
        receiver.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "receipt: msg-1\n" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("RECEIPT"));
        StompTest.assertTrue((String)"Receipt contains correct receipt-id", (frame.indexOf("receipt-id") >= 0 ? 1 : 0) != 0);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertNull((String)"JMS Message does not contain receipt request", (Object)message.getStringProperty("receipt"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithAutoAck() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage(this.getName());
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithAutoAckAndBytesMessage() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendBytesMessage(new byte[]{1, 2, 3, 4, 5});
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        Pattern cl = Pattern.compile("Content-length:\\s*(\\d+)", 2);
        Matcher clMmatcher = cl.matcher(frame);
        StompTest.assertTrue((boolean)clMmatcher.find());
        StompTest.assertEquals((String)"5", (String)clMmatcher.group(1));
        StompTest.assertFalse((boolean)Pattern.compile("type:\\s*null", 2).matcher(frame).find());
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testBytesMessageWithNulls() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\n destination:/queue/" + this.getQueueName() + "\ncontent-length:5" + " \n\n" + "\u0001\u0002\u0000\u0004\u0005" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        StompFrame message = this.stompConnection.receive();
        StompTest.assertTrue((boolean)message.getAction().startsWith("MESSAGE"));
        String length = (String)message.getHeaders().get("content-length");
        StompTest.assertEquals((String)"5", (String)length);
        StompTest.assertEquals((int)5, (int)message.getContent().length);
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSendMultipleBytesMessages() throws Exception {
        int ix;
        int MSG_COUNT = 50;
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        for (ix = 0; ix < 50; ++ix) {
            frame = "SEND\n destination:/queue/" + this.getQueueName() + "\ncontent-length:5" + " \n\n" + "\u0001\u0002\u0000\u0004\u0005" + "\u0000";
            this.stompConnection.sendFrame(frame);
        }
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        for (ix = 0; ix < 50; ++ix) {
            StompFrame message = this.stompConnection.receive();
            StompTest.assertTrue((boolean)message.getAction().startsWith("MESSAGE"));
            String length = (String)message.getHeaders().get("content-length");
            StompTest.assertEquals((String)"5", (String)length);
            StompTest.assertEquals((int)5, (int)message.getContent().length);
        }
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithMessageSentWithProperties() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        TextMessage message = this.session.createTextMessage("Hello World");
        message.setStringProperty("s", "value");
        message.setBooleanProperty("n", false);
        message.setByteProperty("byte", (byte)9);
        message.setDoubleProperty("d", 2.0);
        message.setFloatProperty("f", 6.0f);
        message.setIntProperty("i", 10);
        message.setLongProperty("l", 121L);
        message.setShortProperty("s", (short)12);
        producer.send((Message)message);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testMessagesAreInOrder() throws Exception {
        int i;
        int ctr = 10;
        String[] data = new String[ctr];
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        for (i = 0; i < ctr; ++i) {
            data[i] = this.getName() + i;
            this.sendMessage(data[i]);
        }
        for (i = 0; i < ctr; ++i) {
            frame = this.stompConnection.receiveFrame();
            StompTest.assertTrue((String)"Message not in order", (frame.indexOf(data[i]) >= 0 ? 1 : 0) != 0);
        }
        this.waitForFrameToTakeEffect();
        for (i = 0; i < ctr; ++i) {
            data[i] = this.getName() + ":second:" + i;
            this.sendMessage(data[i]);
        }
        for (i = 0; i < ctr; ++i) {
            frame = this.stompConnection.receiveFrame();
            StompTest.assertTrue((String)"Message not in order", (frame.indexOf(data[i]) >= 0 ? 1 : 0) != 0);
        }
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithAutoAckAndSelector() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "selector: foo = 'zzz'\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage("Ignored message", "foo", "1234");
        this.sendMessage("Real message", "foo", "zzz");
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        StompTest.assertTrue((String)("Should have received the real message but got: " + frame), (frame.indexOf("Real message") > 0 ? 1 : 0) != 0);
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithClientAck() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:client\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage(this.getName());
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        this.stompDisconnect();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertTrue((boolean)message.getJMSRedelivered());
    }

    public void testUnsubscribe() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage("first message");
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "UNSUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        this.sendMessage("second message");
        try {
            frame = this.stompConnection.receiveFrame();
            LOG.info((Object)("Received frame: " + frame));
            StompTest.fail((String)"No message should have been received since subscription was removed");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    public void testTransactionCommit() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "COMMIT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((String)"Should have received a message", (Object)message);
    }

    public void testTransactionRollback() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n" + "first message" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "ABORT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n" + "second message" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "COMMIT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"second message", (String)message.getText().trim());
    }

    public void testDisconnectedClientsAreRemovedFromTheBroker() throws Exception {
        this.assertClients(1);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        this.assertClients(2);
        this.stompConnection.close();
        Thread.sleep(2000L);
        this.assertClients(1);
    }

    public void testConnectNotAuthenticatedWrongUser() throws Exception {
        String frame = "CONNECT\nlogin: dejanb\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
        this.assertClients(1);
    }

    public void testConnectNotAuthenticatedWrongPassword() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: dejanb\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
        this.assertClients(1);
    }

    public void testSendNotAuthorized() throws Exception {
        String frame = "CONNECT\nlogin: guest\npasscode: password\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/USERS." + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
    }

    public void testSubscribeNotAuthorized() throws Exception {
        String frame = "CONNECT\nlogin: guest\npasscode: password\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
    }

    public void testTransformationUnknownTranslator() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:test" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
    }

    public void testTransformationFailed() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_XML + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertNotNull((Object)message.getStringProperty("transformation-error"));
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
    }

    public void testTransformationSendXMLObject() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_XML + "\n\n" + "<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>" + "\u0000";
        this.stompConnection.sendFrame(frame);
        ObjectMessage message = (ObjectMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        SamplePojo object = (SamplePojo)message.getObject();
        StompTest.assertEquals((String)"Dejan", (String)object.getName());
    }

    public void testTransformationSendJSONObject() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_JSON + "\n\n" + "{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}" + "\u0000";
        this.stompConnection.sendFrame(frame);
        ObjectMessage message = (ObjectMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        SamplePojo object = (SamplePojo)message.getObject();
        StompTest.assertEquals((String)"Dejan", (String)object.getName());
    }

    public void testTransformationSubscribeXML() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveJSONObject() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_JSON + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveXMLObject() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveObject() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveXMLObjectAndMap() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage objMessage = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)objMessage);
        MapMessage mapMessage = this.session.createMapMessage();
        mapMessage.setString("name", "Dejan");
        mapMessage.setString("city", "Belgrade");
        producer.send((Message)mapMessage);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>"));
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveJSONObjectAndMap() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage objMessage = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        producer.send((Message)objMessage);
        MapMessage mapMessage = this.session.createMapMessage();
        mapMessage.setString("name", "Dejan");
        mapMessage.setString("city", "Belgrade");
        producer.send((Message)mapMessage);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_JSON + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}"));
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationSendAndReceiveXmlMap() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_MAP_JSON + "\n\n" + this.jsonMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertNotNull((Object)frame);
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlMap.trim()));
        StompTest.assertTrue((boolean)frame.contains("jms-map-xml"));
    }

    public void testTransformationSendAndReceiveJsonMap() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_JSON + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_MAP_XML + "\n\n" + this.xmlMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertNotNull((Object)frame);
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonMap.trim()));
        StompTest.assertTrue((boolean)frame.contains("jms-map-json"));
    }

    public void testTransformationReceiveBytesMessage() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        BytesMessage message = this.session.createBytesMessage();
        message.writeBytes(new byte[]{1, 2, 3, 4, 5});
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        Pattern cl = Pattern.compile("Content-length:\\s*(\\d+)", 2);
        Matcher clMmatcher = cl.matcher(frame);
        StompTest.assertTrue((boolean)clMmatcher.find());
        StompTest.assertEquals((String)"5", (String)clMmatcher.group(1));
        StompTest.assertFalse((boolean)Pattern.compile("type:\\s*null", 2).matcher(frame).find());
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationNotOverrideSubscription() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        message.setStringProperty("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + Stomp.Transformations.JMS_OBJECT_JSON + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith("{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationIgnoreTransformation() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage((Serializable)new SamplePojo("Dejan", "Belgrade"));
        message.setStringProperty("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.endsWith("\n\n"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationSendXMLMap() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_MAP_XML + "\n\n" + this.xmlMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        MapMessage message = (MapMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)message.getString("name"), (String)"Dejan");
    }

    public void testTransformationSendJSONMap() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + Stomp.Transformations.JMS_MAP_JSON + "\n\n" + this.jsonMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        MapMessage message = (MapMessage)consumer.receive(2500L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)message.getString("name"), (String)"Dejan");
    }

    public void testTransformationReceiveXMLMap() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        MapMessage message = this.session.createMapMessage();
        message.setString("name", "Dejan");
        message.setString("city", "Belgrade");
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n" + "transformation:" + Stomp.Transformations.JMS_MAP_XML + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveJSONMap() throws Exception {
        MessageProducer producer = this.session.createProducer((Destination)new ActiveMQQueue("USERS." + this.getQueueName()));
        MapMessage message = this.session.createMapMessage();
        message.setString("name", "Dejan");
        message.setString("city", "Belgrade");
        producer.send((Message)message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n" + "transformation:" + Stomp.Transformations.JMS_MAP_JSON + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testDurableUnsub() throws Exception {
        String domain = "org.apache.activemq";
        ObjectName brokerName = new ObjectName(domain + ":Type=Broker,BrokerName=localhost");
        BrokerViewMBean view = (BrokerViewMBean)this.broker.getManagementContext().newProxyInstance(brokerName, BrokerViewMBean.class, true);
        String frame = "CONNECT\nlogin: system\npasscode: manager\nclient-id:test\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        StompTest.assertEquals((int)view.getDurableTopicSubscribers().length, (int)0);
        frame = "SUBSCRIBE\ndestination:/topic/" + this.getQueueName() + "\n" + "ack:auto\nactivemq.subscriptionName:test\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        StompTest.assertEquals((int)view.getDurableTopicSubscribers().length, (int)1);
        frame = "DISCONNECT\nclient-id:test\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.stompConnect();
        frame = "CONNECT\nlogin: system\npasscode: manager\nclient-id:test\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "UNSUBSCRIBE\ndestination:/topic/" + this.getQueueName() + "\n" + "ack:auto\nactivemq.subscriptionName:test\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        StompTest.assertEquals((int)view.getDurableTopicSubscribers().length, (int)0);
    }

    public void testMessageIdHeader() throws Exception {
        this.stompConnection.connect("system", "manager");
        this.stompConnection.begin("tx1");
        this.stompConnection.send("/queue/" + this.getQueueName(), "msg", "tx1", null);
        this.stompConnection.commit("tx1");
        this.stompConnection.subscribe("/queue/" + this.getQueueName());
        StompFrame stompMessage = this.stompConnection.receive();
        StompTest.assertNull(stompMessage.getHeaders().get("transaction"));
    }

    public void testPrefetchSize() throws Exception {
        this.stompConnection.connect("system", "manager");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("activemq.prefetchSize", "1");
        this.stompConnection.subscribe("/queue/" + this.getQueueName(), "client", headers);
        this.sendMessage("message 1");
        this.sendMessage("message 2");
        this.sendMessage("message 3");
        this.sendMessage("message 4");
        this.sendMessage("message 5");
        StompFrame frame = this.stompConnection.receive();
        StompTest.assertEquals((String)frame.getBody(), (String)"message 1");
        this.stompConnection.begin("tx1");
        this.stompConnection.ack(frame, "tx1");
        StompFrame frame1 = this.stompConnection.receive();
        StompTest.assertEquals((String)frame1.getBody(), (String)"message 2");
        try {
            StompFrame frame2 = this.stompConnection.receive(500L);
            if (frame2 != null) {
                StompTest.fail((String)"Should not have received the second message");
            }
        }
        catch (SocketTimeoutException soe) {
            // empty catch block
        }
        this.stompConnection.ack(frame1, "tx1");
        Thread.sleep(1000L);
        this.stompConnection.abort("tx1");
        this.stompConnection.begin("tx2");
        this.stompConnection.ack(frame, "tx2");
        this.stompConnection.ack(frame1, "tx2");
        StompFrame frame3 = this.stompConnection.receive();
        StompTest.assertEquals((String)frame3.getBody(), (String)"message 3");
        this.stompConnection.ack(frame3, "tx2");
        StompFrame frame4 = this.stompConnection.receive();
        StompTest.assertEquals((String)frame4.getBody(), (String)"message 4");
        this.stompConnection.ack(frame4, "tx2");
        this.stompConnection.commit("tx2");
        this.stompConnection.begin("tx3");
        StompFrame frame5 = this.stompConnection.receive();
        StompTest.assertEquals((String)frame5.getBody(), (String)"message 5");
        this.stompConnection.ack(frame5, "tx3");
        this.stompConnection.commit("tx3");
        this.stompDisconnect();
    }

    public void testTransactionsWithMultipleDestinations() throws Exception {
        this.stompConnection.connect("system", "manager");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("activemq.prefetchSize", "1");
        headers.put("activemq.exclusive", "true");
        this.stompConnection.subscribe("/queue/test1", "client", headers);
        this.stompConnection.begin("ID:tx1");
        headers.clear();
        headers.put("receipt", "ID:msg1");
        this.stompConnection.send("/queue/test2", "test message", "ID:tx1", headers);
        this.stompConnection.commit("ID:tx1");
        Thread.sleep(1000L);
        this.stompConnection.send("/queue/test1", "another message");
        StompFrame frame = this.stompConnection.receive(500L);
        StompTest.assertNotNull((Object)frame);
        this.stompConnection.disconnect();
    }

    public void testTempDestination() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/temp-queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/temp-queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        StompFrame message = this.stompConnection.receive(1000L);
        StompTest.assertEquals((String)"Hello World", (String)message.getBody());
    }

    public void testJMSXUserIDIsSetInMessage() throws Exception {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"system", (String)message.getStringProperty("JMSXUserID"));
    }

    public void testJMSXUserIDIsSetInStompMessage() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        StompFrame message = this.stompConnection.receive(5000L);
        StompTest.assertEquals((String)"system", (String)((String)message.getHeaders().get("JMSXUserID")));
    }

    public void testClientSetMessageIdIsIgnored() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("message-id", "Thisisnotallowed");
        headers.put("timestamp", "1234");
        headers.put("redelivered", "true");
        headers.put("subscription", "Thisisnotallowed");
        headers.put("JMSXUserID", "Thisisnotallowed");
        this.stompConnection.connect("system", "manager");
        this.stompConnection.send("/queue/" + this.getQueueName(), "msg", null, headers);
        this.stompConnection.subscribe("/queue/" + this.getQueueName());
        StompFrame stompMessage = this.stompConnection.receive();
        Map mess_headers = new HashMap();
        mess_headers = stompMessage.getHeaders();
        StompTest.assertFalse((boolean)"Thisisnotallowed".equals(mess_headers.get("message-id")));
        StompTest.assertFalse((boolean)"1234".equals(mess_headers.get("timestamp")));
        StompTest.assertNull(mess_headers.get("redelivered"));
        StompTest.assertNull(mess_headers.get("subscription"));
        StompTest.assertEquals((String)"system", (String)((String)mess_headers.get("JMSXUserID")));
    }

    protected void assertClients(int expected) throws Exception {
        org.apache.activemq.broker.Connection[] clients = this.broker.getBroker().getClients();
        int actual = clients.length;
        StompTest.assertEquals((String)"Number of clients", (int)expected, (int)actual);
    }

    protected void waitForFrameToTakeEffect() throws InterruptedException {
        Thread.sleep(2000L);
    }
}

