/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryUsageTest {
    MemoryUsage underTest;
    ThreadPoolExecutor executor;

    @Test
    public final void testPercentUsageNeedsNoThread() {
        int activeThreadCount = Thread.activeCount();
        this.underTest.setLimit(10L);
        this.underTest.start();
        this.underTest.increaseUsage(1L);
        Assert.assertEquals((String)"usage is correct", (long)10L, (long)this.underTest.getPercentUsage());
        Assert.assertEquals((String)"no new thread created withough listener or callback", (long)activeThreadCount, (long)Thread.activeCount());
    }

    @Test
    public final void testAddUsageListenerStartsThread() throws Exception {
        int activeThreadCount = Thread.activeCount();
        this.underTest = new MemoryUsage();
        this.underTest.setExecutor(this.executor);
        this.underTest.setLimit(10L);
        this.underTest.start();
        final CountDownLatch called = new CountDownLatch(1);
        final String[] listnerThreadNameHolder = new String[1];
        this.underTest.addUsageListener(new UsageListener(){

            public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
                called.countDown();
                listnerThreadNameHolder[0] = Thread.currentThread().toString();
            }
        });
        this.underTest.increaseUsage(1L);
        Assert.assertTrue((String)"listner was called", (boolean)called.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"listner called from another thread", (!Thread.currentThread().toString().equals(listnerThreadNameHolder[0]) ? 1 : 0) != 0);
        Assert.assertEquals((String)"usage is correct", (long)10L, (long)this.underTest.getPercentUsage());
        Assert.assertEquals((String)"new thread created with listener", (long)(activeThreadCount + 1), (long)Thread.activeCount());
    }

    @Before
    public void setUp() throws Exception {
        this.underTest = new MemoryUsage();
        this.executor = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Usage Async Task");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.underTest.setExecutor(this.executor);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.underTest);
        this.underTest.stop();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

