/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.List;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.TextMessage;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.SocketProxy;

public class BrokerQueueNetworkWithDisconnectTest
extends JmsMultipleBrokersTestSupport {
    private static final int NETWORK_DOWN_TIME = 5000;
    protected static final int MESSAGE_COUNT = 200;
    private static final String HUB = "HubBroker";
    private static final String SPOKE = "SpokeBroker";
    private SocketProxy socketProxy;
    private long networkDownTimeStart;
    public boolean useDuplexNetworkBridge;
    public boolean sumulateStalledNetwork;

    public void initCombosForTestSendOnAReceiveOnBWithTransportDisconnect() {
        this.addCombinationValues("useDuplexNetworkBridge", new Object[]{Boolean.TRUE, Boolean.FALSE});
        this.addCombinationValues("sumulateStalledNetwork", new Object[]{Boolean.TRUE});
    }

    public void testSendOnAReceiveOnBWithTransportDisconnect() throws Exception {
        this.bridgeBrokers(SPOKE, HUB);
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer client = this.createConsumer(HUB, (Destination)dest);
        this.sleep(600);
        this.sendMessages(SPOKE, (Destination)dest, 200);
        MessageIdList msgs = this.getConsumerMessages(HUB, client);
        msgs.waitForMessagesToArrive(200);
        BrokerQueueNetworkWithDisconnectTest.assertTrue((String)("At least message 200 must be recieved, duplicates are expected, count=" + msgs.getMessageCount()), (200 <= msgs.getMessageCount() ? 1 : 0) != 0);
    }

    protected void startAllBrokers() throws Exception {
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(HUB);
        brokerItem.broker.start();
        brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(SPOKE);
        brokerItem.broker.start();
        this.sleep(600);
    }

    public void setUp() throws Exception {
        this.networkDownTimeStart = 0L;
        super.setAutoFail(true);
        super.setUp();
        String options = "?persistent=true&useJmx=false&deleteAllMessagesOnStartup=true";
        this.createBroker(new URI("broker:(tcp://localhost:61617)/HubBroker?persistent=true&useJmx=false&deleteAllMessagesOnStartup=true"));
        this.createBroker(new URI("broker:(tcp://localhost:61616)/SpokeBroker?persistent=true&useJmx=false&deleteAllMessagesOnStartup=true"));
    }

    public static Test suite() {
        return BrokerQueueNetworkWithDisconnectTest.suite(BrokerQueueNetworkWithDisconnectTest.class);
    }

    protected void onSend(int i, TextMessage msg) {
        this.sleep(50);
        if (i == 50 || i == 150) {
            if (this.sumulateStalledNetwork) {
                this.socketProxy.pause();
            } else {
                this.socketProxy.close();
            }
            this.networkDownTimeStart = System.currentTimeMillis();
        } else if (this.networkDownTimeStart > 0L) {
            if (this.networkDownTimeStart + 5000L < System.currentTimeMillis()) {
                if (this.sumulateStalledNetwork) {
                    this.socketProxy.goOn();
                } else {
                    this.socketProxy.reopen();
                }
                this.networkDownTimeStart = 0L;
            } else {
                this.sleep(500);
            }
        }
        super.onSend(i, msg);
    }

    private void sleep(int milliSecondTime) {
        try {
            Thread.sleep(milliSecondTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected NetworkConnector bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker, boolean dynamicOnly, int networkTTL, boolean conduit, boolean failover) throws Exception {
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            this.socketProxy = new SocketProxy(remoteURI);
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI("static:(" + this.socketProxy.getUrl() + "?wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000)?useExponentialBackOff=false"));
            connector.setDynamicOnly(dynamicOnly);
            connector.setNetworkTTL(networkTTL);
            localBroker.addNetworkConnector((NetworkConnector)connector);
            maxSetupTime = 2000;
            if (this.useDuplexNetworkBridge) {
                connector.setDuplex(true);
            }
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }
}

