/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.usecases.ConsumeTopicPrefetchTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumeQueuePrefetchTest
extends ConsumeTopicPrefetchTest {
    private static final Log LOG = LogFactory.getLog(ConsumeQueuePrefetchTest.class);

    protected void setUp() throws Exception {
        this.topic = false;
        super.setUp();
    }

    public void testInflightWithConsumerPerMessage() throws JMSException {
        int i;
        this.makeMessages(this.prefetchSize);
        LOG.info((Object)("About to send and receive: " + this.prefetchSize + " on destination: " + this.destination + " of type: " + this.destination.getClass().getName()));
        for (i = 0; i < this.prefetchSize; ++i) {
            TextMessage message = this.session.createTextMessage(this.messageTexts[i]);
            this.producer.send((Message)message);
        }
        this.validateConsumerPrefetch(this.getSubject(), this.prefetchSize);
        for (i = 0; i < this.prefetchSize; i += 20) {
            this.consumer.close();
            this.consumer = this.session.createConsumer(this.destination);
            this.validateConsumerPrefetch(this.getSubject(), this.prefetchSize - i);
            for (int j = 0; j < 20; ++j) {
                TextMessage message = this.consumeMessge(i + j);
                message.acknowledge();
            }
        }
    }
}

