/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;

public class DurableSubscriptionActivationTest
extends TestSupport {
    private BrokerService broker;
    private Connection connection;
    private ActiveMQTopic topic;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        return rc;
    }

    protected void setUp() throws Exception {
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    protected void restartBroker() throws Exception {
        this.destroyBroker();
        this.createBroker();
    }

    private void createBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setKeepDurableSubsActive(true);
        this.broker.setPersistent(true);
        AMQPersistenceAdapter persistenceAdapter = new AMQPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("activemq-data/" + this.getName()));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.setBrokerName(this.getName());
        this.broker.setDestinations(new ActiveMQDestination[]{this.topic});
        this.broker.start();
        this.connection = this.createConnection();
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void testActivateWithExistingTopic() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableSubscriptionActivationTest.assertTrue((String)"More than one consumer.", (d.getConsumers().size() == 1 ? 1 : 0) != 0);
        this.restartBroker();
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        DurableSubscriptionActivationTest.assertTrue((String)"More than one consumer.", (d.getConsumers().size() == 1 ? 1 : 0) != 0);
        this.connection.close();
        this.connection = this.createConnection();
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        DurableSubscriptionActivationTest.assertTrue((String)"More than one consumer.", (d.getConsumers().size() == 1 ? 1 : 0) != 0);
    }
}

