/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;

public class DurableSubscriptionReactivationTest
extends EmbeddedBrokerTestSupport {
    public boolean keepDurableSubsActive;

    public void initCombosForTestReactivateKeepaliveSubscription() {
        this.addCombinationValues("keepDurableSubsActive", new Object[]{new Boolean(true), new Boolean(false)});
    }

    public void testReactivateKeepaliveSubscription() throws Exception {
        Connection connection = this.createConnection();
        connection.setClientID("cliID");
        connection.start();
        Session session = connection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.createDestination(), "subName");
        subscriber.close();
        connection.close();
        connection = this.createConnection();
        connection.start();
        session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.createDestination());
        producer.send(session.createMessage());
        connection.close();
        connection = this.createConnection();
        connection.setClientID("cliID");
        connection.start();
        session = connection.createSession(false, 1);
        subscriber = session.createDurableSubscriber((Topic)this.createDestination(), "subName");
        Message message = subscriber.receive(1000L);
        subscriber.close();
        connection.close();
        DurableSubscriptionReactivationTest.assertNotNull((String)"Message not received.", (Object)message);
    }

    protected void setUp() throws Exception {
        this.useTopic = true;
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = super.createBroker();
        answer.setKeepDurableSubsActive(this.keepDurableSubsActive);
        answer.setPersistenceAdapter((PersistenceAdapter)new JDBCPersistenceAdapter());
        return answer;
    }

    protected boolean isPersistent() {
        return true;
    }

    public static Test suite() {
        return DurableSubscriptionReactivationTest.suite(DurableSubscriptionReactivationTest.class);
    }
}

