/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class DurableSubscriptionUnsubscribeTest
extends TestSupport {
    BrokerService broker = null;
    Connection connection = null;
    ActiveMQTopic topic;

    public void testJMXSubscriptionUnsubscribe() throws Exception {
        this.doJMXUnsubscribe(false);
    }

    public void testJMXSubscriptionUnsubscribeWithRestart() throws Exception {
        this.doJMXUnsubscribe(true);
    }

    public void testConnectionSubscriptionUnsubscribe() throws Exception {
        this.doConnectionUnsubscribe(false);
    }

    public void testConnectionSubscriptionUnsubscribeWithRestart() throws Exception {
        this.doConnectionUnsubscribe(true);
    }

    public void testDirectSubscriptionUnsubscribe() throws Exception {
        this.doDirectUnsubscribe(false);
    }

    public void testDirectubscriptionUnsubscribeWithRestart() throws Exception {
        this.doDirectUnsubscribe(true);
    }

    public void doJMXUnsubscribe(boolean restart) throws Exception {
        for (int i = 0; i < 100; ++i) {
            Session session = this.connection.createSession(false, 1);
            session.createDurableSubscriber((Topic)this.topic, "SubsId" + i);
            session.close();
        }
        Thread.sleep(2000L);
        if (restart) {
            this.stopBroker();
            this.startBroker(false);
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName[] subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        ObjectName[] inactive = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        for (ObjectName subscription : subscriptions) {
            mbs.invoke(subscription, "destroy", null, null);
        }
        for (ObjectName subscription : inactive) {
            mbs.invoke(subscription, "destroy", null, null);
        }
        Thread.sleep(2000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
    }

    public void testInactiveSubscriptions() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        ObjectName[] subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)1, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        session.close();
        Thread.sleep(1000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)1, (int)subscriptions.length);
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        Thread.sleep(1000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)1, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        session.close();
        session = this.connection.createSession(false, 1);
        Thread.sleep(1000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)1, (int)subscriptions.length);
        session.unsubscribe("SubsId");
        Thread.sleep(1000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        session.close();
    }

    public void doConnectionUnsubscribe(boolean restart) throws Exception {
        for (int i = 0; i < 100; ++i) {
            Session session = this.connection.createSession(false, 1);
            session.createDurableSubscriber((Topic)this.topic, "SubsId" + i);
            session.close();
        }
        Thread.sleep(2000L);
        if (restart) {
            this.stopBroker();
            this.startBroker(false);
        }
        ObjectName[] subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)100, (int)subscriptions.length);
        for (int i = 0; i < 100; ++i) {
            Session session = this.connection.createSession(false, 1);
            session.unsubscribe("SubsId" + i);
            session.close();
        }
        Thread.sleep(2000L);
        subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
    }

    public void doDirectUnsubscribe(boolean restart) throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            Session session = this.connection.createSession(false, 1);
            session.createDurableSubscriber((Topic)this.topic, "SubsId" + i);
            session.close();
        }
        Thread.sleep(2000L);
        if (restart) {
            this.stopBroker();
            this.startBroker(false);
        }
        for (i = 0; i < 100; ++i) {
            RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
            info.setClientId(this.getName());
            info.setSubscriptionName("SubsId" + i);
            ConnectionContext context = new ConnectionContext();
            context.setBroker(this.broker.getRegionBroker());
            context.setClientId(this.getName());
            this.broker.getRegionBroker().removeSubscription(context, info);
        }
        Thread.sleep(2000L);
        ObjectName[] subscriptions = this.broker.getAdminView().getDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
        subscriptions = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        DurableSubscriptionUnsubscribeTest.assertEquals((int)0, (int)subscriptions.length);
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setUseJmx(true);
        this.broker.setBrokerName(this.getName());
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("activemq-data/" + this.getName()));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.broker.start();
        this.connection = this.createConnection();
    }

    private void stopBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName() + "?waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.topic = (ActiveMQTopic)this.createDestination();
        this.startBroker(true);
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        rc.start();
        return rc;
    }
}

