/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;

public class DurableUnsubscribeTest
extends TestSupport {
    private BrokerService broker;
    private Connection connection;
    private ActiveMQTopic topic;

    public void testUnsubscribe() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        session.close();
        Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableUnsubscribeTest.assertEquals((String)"Subscription is missing.", (int)1, (int)d.getConsumers().size());
        session = this.connection.createSession(false, 1);
        session.unsubscribe("SubsId");
        session.close();
        DurableUnsubscribeTest.assertEquals((String)"Subscription exists.", (int)0, (int)d.getConsumers().size());
    }

    public void testDestroy() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId2");
        session.close();
        this.connection.close();
        this.connection = null;
        Thread.sleep(1000L);
        Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableUnsubscribeTest.assertEquals((String)"Subscription is missing.", (int)1, (int)d.getConsumers().size());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName[] subNames = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        mbs.invoke(subNames[0], "destroy", new Object[0], new String[0]);
        DurableUnsubscribeTest.assertEquals((String)"Subscription exists.", (int)0, (int)d.getConsumers().size());
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        return rc;
    }

    protected void setUp() throws Exception {
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.setBrokerName(this.getName());
        this.broker.start();
        this.connection = this.createConnection();
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }
}

