/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;

public class ManagedDurableSubscriptionTest
extends TestSupport {
    BrokerService broker = null;
    Connection connection = null;
    ActiveMQTopic topic;

    public void testJMXSubscriptions() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        session.close();
        this.stopBroker();
        this.startBroker();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName inactiveSubscriptionObjectName = this.broker.getAdminView().getInactiveDurableTopicSubscribers()[0];
        Object inactive = mbs.getAttribute(inactiveSubscriptionObjectName, "Active");
        ManagedDurableSubscriptionTest.assertTrue((String)"Subscription is active.", (boolean)Boolean.FALSE.equals(inactive));
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        ObjectName activeSubscriptionObjectName = this.broker.getAdminView().getDurableTopicSubscribers()[0];
        Object active = mbs.getAttribute(activeSubscriptionObjectName, "Active");
        ManagedDurableSubscriptionTest.assertTrue((String)"Subscription is INactive.", (boolean)Boolean.TRUE.equals(active));
        this.connection.close();
        this.connection = null;
        inactive = mbs.getAttribute(inactiveSubscriptionObjectName, "Active");
        ManagedDurableSubscriptionTest.assertTrue((String)"Subscription is active.", (boolean)Boolean.FALSE.equals(inactive));
    }

    private void startBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setKeepDurableSubsActive(false);
        this.broker.setPersistent(true);
        KahaPersistenceAdapter persistenceAdapter = new KahaPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("activemq-data/" + this.getName()));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.setUseJmx(true);
        this.broker.setBrokerName(this.getName());
        this.broker.start();
        this.connection = this.createConnection();
    }

    private void stopBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName() + "?waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.topic = (ActiveMQTopic)this.createDestination();
        this.startBroker();
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }

    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        rc.start();
        return rc;
    }
}

