/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageGroupNewConsumerTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(MessageGroupNewConsumerTest.class);
    private Connection connection;
    private CountDownLatch latchMessagesCreated = new CountDownLatch(1);
    private CountDownLatch latchGroupsAcquired = new CountDownLatch(1);
    private static final String[] groupNames = new String[]{"GrA", "GrB", "GrC"};
    private int messagesSent;
    private int messagesRecvd1;
    private int messagesRecvd2;
    private static final String connStr = "vm://localhost?broker.persistent=false&broker.useJmx=false&jms.prefetchPolicy.all=1";

    public void testNewConsumer() throws JMSException, InterruptedException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(connStr);
        this.connection = factory.createConnection();
        this.connection.start();
        final String queueName = ((Object)((Object)this)).getClass().getSimpleName();
        Thread producerThread = new Thread(){

            public void run() {
                try {
                    Session session = MessageGroupNewConsumerTest.this.connection.createSession(true, 0);
                    Queue queue = session.createQueue(queueName);
                    MessageProducer prod = session.createProducer((Destination)queue);
                    for (int i = 0; i < 10; ++i) {
                        for (String group : groupNames) {
                            Message message = MessageGroupNewConsumerTest.this.generateMessage(session, group, i + 1);
                            prod.send(message);
                            session.commit();
                            MessageGroupNewConsumerTest.this.messagesSent++;
                        }
                        LOG.info((Object)("Sent message seq " + (i + 1)));
                        if (i == 0) {
                            MessageGroupNewConsumerTest.this.latchMessagesCreated.countDown();
                        }
                        if (i == 2) {
                            LOG.info((Object)"Prod: Waiting for groups");
                            MessageGroupNewConsumerTest.this.latchGroupsAcquired.await();
                        }
                        Thread.sleep(20L);
                    }
                    LOG.info((Object)(MessageGroupNewConsumerTest.this.messagesSent + " messages sent"));
                    prod.close();
                    session.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Producer failed", (Throwable)e);
                }
            }
        };
        final Thread consumerThread1 = new Thread(){

            public void run() {
                try {
                    Message message;
                    Session session = MessageGroupNewConsumerTest.this.connection.createSession(true, 0);
                    Queue queue = session.createQueue(queueName);
                    MessageConsumer con1 = session.createConsumer((Destination)queue);
                    MessageGroupNewConsumerTest.this.latchMessagesCreated.await();
                    while ((message = con1.receive(1000L)) != null) {
                        LOG.info((Object)("Con1 got message " + MessageGroupNewConsumerTest.this.formatMessage(message)));
                        session.commit();
                        MessageGroupNewConsumerTest.this.messagesRecvd1++;
                        if (MessageGroupNewConsumerTest.this.messagesRecvd1 == groupNames.length) {
                            LOG.info((Object)"All groups acquired");
                            MessageGroupNewConsumerTest.this.latchGroupsAcquired.countDown();
                            Thread.sleep(1000L);
                        }
                        Thread.sleep(50L);
                    }
                    LOG.info((Object)(MessageGroupNewConsumerTest.this.messagesRecvd1 + " messages received by consumer1"));
                    con1.close();
                    session.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Consumer 1 failed", (Throwable)e);
                }
            }
        };
        Thread consumerThread2 = new Thread(){

            public void run() {
                try {
                    MessageGroupNewConsumerTest.this.latchGroupsAcquired.await();
                    while (consumerThread1.isAlive()) {
                        Message message;
                        LOG.info((Object)"(re)starting consumer2");
                        Session session = MessageGroupNewConsumerTest.this.connection.createSession(true, 0);
                        Queue queue = session.createQueue(queueName);
                        MessageConsumer con2 = session.createConsumer((Destination)queue);
                        while ((message = con2.receive(500L)) != null) {
                            LOG.info((Object)("Con2 got message       " + MessageGroupNewConsumerTest.this.formatMessage(message)));
                            session.commit();
                            MessageGroupNewConsumerTest.this.messagesRecvd2++;
                            Thread.sleep(50L);
                        }
                        con2.close();
                        session.close();
                    }
                    LOG.info((Object)(MessageGroupNewConsumerTest.this.messagesRecvd2 + " messages received by consumer2"));
                }
                catch (Exception e) {
                    LOG.error((Object)"Consumer 2 failed", (Throwable)e);
                }
            }
        };
        consumerThread2.start();
        consumerThread1.start();
        producerThread.start();
        producerThread.join();
        consumerThread1.join();
        consumerThread2.join();
        this.connection.close();
        MessageGroupNewConsumerTest.assertEquals((String)"consumer 2 should not get any messages", (int)0, (int)this.messagesRecvd2);
        MessageGroupNewConsumerTest.assertEquals((String)"consumer 1 should get all the messages", (int)this.messagesSent, (int)this.messagesRecvd1);
        MessageGroupNewConsumerTest.assertTrue((String)"producer failed to send any messages", (this.messagesSent > 0 ? 1 : 0) != 0);
    }

    public Message generateMessage(Session session, String groupId, int seq) throws JMSException {
        TextMessage m = session.createTextMessage();
        m.setJMSType("TEST_MESSAGE");
        m.setStringProperty("JMSXGroupID", groupId);
        m.setIntProperty("JMSXGroupSeq", seq);
        m.setText("<?xml?><testMessage/>");
        return m;
    }

    public String formatMessage(Message m) {
        try {
            return m.getStringProperty("JMSXGroupID") + "-" + m.getIntProperty("JMSXGroupSeq") + "-" + m.getBooleanProperty("JMSXGroupFirstForConsumer");
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }
}

