/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Set;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerAndConnectionTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewConsumerCreatesDestinationTest
extends EmbeddedBrokerAndConnectionTestSupport {
    private static final Log LOG = LogFactory.getLog(NewConsumerCreatesDestinationTest.class);
    private ActiveMQQueue wildcard;

    public void testNewConsumerCausesNewDestinationToBeAutoCreated() throws Exception {
        String wildcardText = "org.*" + this.getDestinationString().substring("org.apache".length());
        this.wildcard = new ActiveMQQueue(wildcardText);
        LOG.info((Object)("Using wildcard: " + this.wildcard));
        LOG.info((Object)("on destination: " + this.destination));
        this.assertDestinationCreated((Destination)this.destination, false);
        this.assertDestinationCreated((Destination)this.wildcard, false);
        Session session = this.connection.createSession(false, 1);
        session.createConsumer((Destination)this.destination);
        this.assertDestinationCreated((Destination)this.destination, true);
        this.assertDestinationCreated((Destination)this.wildcard, true);
    }

    protected void assertDestinationCreated(Destination destination, boolean expected) throws Exception {
        Set answer = this.broker.getBroker().getDestinations((ActiveMQDestination)destination);
        int size = expected ? 1 : 0;
        NewConsumerCreatesDestinationTest.assertEquals((String)("Size of found destinations: " + answer), (int)size, (int)answer.size());
    }
}

