/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.Serializable;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.usecases.MyObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectMessageNotSerializableTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(ObjectMessageNotSerializableTest.class);
    BrokerService broker;
    AtomicInteger numReceived = new AtomicInteger(0);
    final Vector<Throwable> exceptions = new Vector();

    public static Test suite() {
        return ObjectMessageNotSerializableTest.suite(ObjectMessageNotSerializableTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ObjectMessageNotSerializableTest.suite());
    }

    protected void setUp() throws Exception {
        this.exceptions.clear();
        this.broker = this.createBroker();
    }

    public void testSendNotSerializeableObjectMessage() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("testQ");
        MyObject obj = new MyObject("A message");
        CountDownLatch consumerStarted = new CountDownLatch(1);
        Thread vmConsumerThread = new Thread("Consumer Thread", (ActiveMQDestination)destination, consumerStarted){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ CountDownLatch val$consumerStarted;
            {
                this.val$destination = activeMQDestination;
                this.val$consumerStarted = countDownLatch;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    factory.setOptimizedMessageDispatch(true);
                    factory.setObjectMessageSerializationDefered(true);
                    factory.setCopyMessageOnSend(false);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.val$destination);
                    connection.start();
                    this.val$consumerStarted.countDown();
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)consumer.receive(30000L);
                    if (message != null) {
                        MyObject object = (MyObject)message.getObject();
                        LOG.info((Object)("Got message " + object.getMessage()));
                        ObjectMessageNotSerializableTest.this.numReceived.incrementAndGet();
                    }
                    consumer.close();
                }
                catch (Throwable ex) {
                    ObjectMessageNotSerializableTest.this.exceptions.add(ex);
                }
            }
        };
        vmConsumerThread.start();
        Thread producingThread = new Thread("Producing Thread", (ActiveMQDestination)destination, obj){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ MyObject val$obj;
            {
                this.val$destination = activeMQDestination;
                this.val$obj = myObject;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    factory.setOptimizedMessageDispatch(true);
                    factory.setObjectMessageSerializationDefered(true);
                    factory.setCopyMessageOnSend(false);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)this.val$destination);
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)session.createObjectMessage();
                    message.setObject((Serializable)this.val$obj);
                    producer.send((Message)message);
                    producer.close();
                }
                catch (Throwable ex) {
                    ObjectMessageNotSerializableTest.this.exceptions.add(ex);
                }
            }
        };
        ObjectMessageNotSerializableTest.assertTrue((String)"consumers started", (boolean)consumerStarted.await(10L, TimeUnit.SECONDS));
        producingThread.start();
        vmConsumerThread.join();
        producingThread.join();
        ObjectMessageNotSerializableTest.assertEquals((String)"writeObject called", (int)0, (int)obj.getWriteObjectCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"readObject called", (int)0, (int)obj.getReadObjectCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"readObjectNoData called", (int)0, (int)obj.getReadObjectNoDataCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"Got expected messages", (int)1, (int)this.numReceived.get());
        ObjectMessageNotSerializableTest.assertTrue((String)("no unexpected exceptions: " + this.exceptions), (boolean)this.exceptions.isEmpty());
    }

    public void testSendNotSerializeableObjectMessageOverTcp() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("testTopic");
        MyObject obj = new MyObject("A message");
        CountDownLatch consumerStarted = new CountDownLatch(3);
        Vector exceptions = new Vector();
        Thread vmConsumerThread = new Thread("Consumer Thread", (ActiveMQDestination)destination, consumerStarted, exceptions){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ CountDownLatch val$consumerStarted;
            final /* synthetic */ Vector val$exceptions;
            {
                this.val$destination = activeMQDestination;
                this.val$consumerStarted = countDownLatch;
                this.val$exceptions = vector;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    factory.setOptimizedMessageDispatch(true);
                    factory.setObjectMessageSerializationDefered(true);
                    factory.setCopyMessageOnSend(false);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.val$destination);
                    connection.start();
                    this.val$consumerStarted.countDown();
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)consumer.receive(30000L);
                    if (message != null) {
                        MyObject object = (MyObject)message.getObject();
                        LOG.info((Object)("Got message " + object.getMessage()));
                        ObjectMessageNotSerializableTest.this.numReceived.incrementAndGet();
                    }
                    consumer.close();
                }
                catch (Throwable ex) {
                    this.val$exceptions.add(ex);
                }
            }
        };
        vmConsumerThread.start();
        Thread tcpConsumerThread = new Thread("Consumer Thread", (ActiveMQDestination)destination, consumerStarted, exceptions){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ CountDownLatch val$consumerStarted;
            final /* synthetic */ Vector val$exceptions;
            {
                this.val$destination = activeMQDestination;
                this.val$consumerStarted = countDownLatch;
                this.val$exceptions = vector;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(((TransportConnector)ObjectMessageNotSerializableTest.this.broker.getTransportConnectors().get(0)).getConnectUri());
                    factory.setOptimizedMessageDispatch(true);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.val$destination);
                    connection.start();
                    this.val$consumerStarted.countDown();
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)consumer.receive(30000L);
                    if (message != null) {
                        MyObject object = (MyObject)message.getObject();
                        LOG.info((Object)("Got message " + object.getMessage()));
                        ObjectMessageNotSerializableTest.this.numReceived.incrementAndGet();
                        Assert.assertEquals((String)"readObject called", (int)1, (int)object.getReadObjectCalled());
                    }
                    consumer.close();
                }
                catch (Throwable ex) {
                    this.val$exceptions.add(ex);
                }
            }
        };
        tcpConsumerThread.start();
        Thread notherVmConsumerThread = new Thread("Consumer Thread", (ActiveMQDestination)destination, consumerStarted, exceptions){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ CountDownLatch val$consumerStarted;
            final /* synthetic */ Vector val$exceptions;
            {
                this.val$destination = activeMQDestination;
                this.val$consumerStarted = countDownLatch;
                this.val$exceptions = vector;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    factory.setOptimizedMessageDispatch(true);
                    factory.setObjectMessageSerializationDefered(true);
                    factory.setCopyMessageOnSend(false);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.val$destination);
                    connection.start();
                    this.val$consumerStarted.countDown();
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)consumer.receive(30000L);
                    if (message != null) {
                        MyObject object = (MyObject)message.getObject();
                        LOG.info((Object)("Got message " + object.getMessage()));
                        ObjectMessageNotSerializableTest.this.numReceived.incrementAndGet();
                    }
                    consumer.close();
                }
                catch (Throwable ex) {
                    this.val$exceptions.add(ex);
                }
            }
        };
        notherVmConsumerThread.start();
        Thread producingThread = new Thread("Producing Thread", (ActiveMQDestination)destination, obj, exceptions){
            final /* synthetic */ ActiveMQDestination val$destination;
            final /* synthetic */ MyObject val$obj;
            final /* synthetic */ Vector val$exceptions;
            {
                this.val$destination = activeMQDestination;
                this.val$obj = myObject;
                this.val$exceptions = vector;
                super(x0);
            }

            public void run() {
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    factory.setOptimizedMessageDispatch(true);
                    factory.setObjectMessageSerializationDefered(true);
                    factory.setCopyMessageOnSend(false);
                    Connection connection = factory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)this.val$destination);
                    ActiveMQObjectMessage message = (ActiveMQObjectMessage)session.createObjectMessage();
                    message.setObject((Serializable)this.val$obj);
                    producer.send((Message)message);
                    producer.close();
                }
                catch (Throwable ex) {
                    this.val$exceptions.add(ex);
                }
            }
        };
        ObjectMessageNotSerializableTest.assertTrue((String)"consumers started", (boolean)consumerStarted.await(10L, TimeUnit.SECONDS));
        producingThread.start();
        vmConsumerThread.join();
        tcpConsumerThread.join();
        notherVmConsumerThread.join();
        producingThread.join();
        ObjectMessageNotSerializableTest.assertEquals((String)"writeObject called", (int)1, (int)obj.getWriteObjectCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"readObject called", (int)0, (int)obj.getReadObjectCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"readObjectNoData called", (int)0, (int)obj.getReadObjectNoDataCalled());
        ObjectMessageNotSerializableTest.assertEquals((String)"Got expected messages", (int)3, (int)this.numReceived.get());
        ObjectMessageNotSerializableTest.assertTrue((String)("no unexpected exceptions: " + exceptions), (boolean)exceptions.isEmpty());
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.addConnector("tcp://localhost:0");
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }
}

