/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import junit.framework.TestCase;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;

public class DataByteArrayInputStreamTest
extends TestCase {
    public void testNonAscii() throws Exception {
        char t;
        this.doMarshallUnMarshallValidation("mei\u00dfen");
        String accumulator = new String();
        int test = 0;
        while (Character.isDefined(test)) {
            String toTest = String.valueOf((char)test);
            accumulator = accumulator + toTest;
            this.doMarshallUnMarshallValidation(toTest);
            ++test;
        }
        int massiveThreeByteCharValue = 4095;
        String toTest = String.valueOf((char)massiveThreeByteCharValue);
        accumulator = accumulator + toTest;
        this.doMarshallUnMarshallValidation(String.valueOf((char)massiveThreeByteCharValue));
        this.doMarshallUnMarshallValidation(accumulator);
        int max = 65535;
        accumulator = String.valueOf(t);
        for (t = '\u0800'; t < '\uffff'; t = (char)(t + '\u0001')) {
            String val = String.valueOf(t);
            accumulator = accumulator + val;
            this.doMarshallUnMarshallValidation(val);
        }
        while (accumulator.length() > 20000) {
            accumulator = accumulator.substring(20000);
        }
        this.doMarshallUnMarshallValidation(accumulator);
    }

    void doMarshallUnMarshallValidation(String value) throws Exception {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream();
        out.writeBoolean(true);
        out.writeUTF(value);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        in.readBoolean();
        String readBack = in.readUTF();
        DataByteArrayInputStreamTest.assertEquals((String)value, (String)readBack);
    }
}

