/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketProxy {
    private static final transient Log LOG = LogFactory.getLog(SocketProxy.class);
    public static final int ACCEPT_TIMEOUT_MILLIS = 100;
    private URI proxyUrl;
    private URI target;
    private Acceptor acceptor;
    private ServerSocket serverSocket;
    private CountDownLatch closed = new CountDownLatch(1);
    public List<Connection> connections = new LinkedList<Connection>();
    private int listenPort = 0;
    private int receiveBufferSize = -1;

    public SocketProxy() throws Exception {
    }

    public SocketProxy(URI uri) throws Exception {
        this(0, uri);
    }

    public SocketProxy(int port, URI uri) throws Exception {
        this.listenPort = port;
        this.target = uri;
        this.open();
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setTarget(URI tcpBrokerUri) {
        this.target = tcpBrokerUri;
    }

    public void open() throws Exception {
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        if (this.receiveBufferSize > 0) {
            this.serverSocket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.proxyUrl == null) {
            this.serverSocket.bind(new InetSocketAddress(this.listenPort));
            this.proxyUrl = this.urlFromSocket(this.target, this.serverSocket);
        } else {
            this.serverSocket.bind(new InetSocketAddress(this.proxyUrl.getPort()));
        }
        this.acceptor = new Acceptor(this.serverSocket, this.target);
        new Thread(null, this.acceptor, "SocketProxy-Acceptor-" + this.serverSocket.getLocalPort()).start();
        this.closed = new CountDownLatch(1);
    }

    public URI getUrl() {
        return this.proxyUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Connection> connections;
        List<Connection> list = this.connections;
        synchronized (list) {
            connections = new ArrayList<Connection>(this.connections);
        }
        LOG.info((Object)("close, numConnectons=" + connections.size()));
        for (Connection con : connections) {
            this.closeConnection(con);
        }
        this.acceptor.close();
        this.closed.countDown();
    }

    public boolean waitUntilClosed(long timeoutSeconds) throws InterruptedException {
        return this.closed.await(timeoutSeconds, TimeUnit.SECONDS);
    }

    public void reopen() {
        LOG.info((Object)"reopen");
        try {
            this.open();
        }
        catch (Exception e) {
            LOG.debug((Object)("exception on reopen url:" + this.getUrl()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        List<Connection> list = this.connections;
        synchronized (list) {
            LOG.info((Object)("pause, numConnectons=" + this.connections.size()));
            this.acceptor.pause();
            for (Connection con : this.connections) {
                con.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goOn() {
        List<Connection> list = this.connections;
        synchronized (list) {
            LOG.info((Object)("goOn, numConnectons=" + this.connections.size()));
            for (Connection con : this.connections) {
                con.goOn();
            }
        }
        this.acceptor.goOn();
    }

    private void closeConnection(Connection c) {
        try {
            c.close();
        }
        catch (Exception e) {
            LOG.debug((Object)("exception on close of: " + c), (Throwable)e);
        }
    }

    private URI urlFromSocket(URI uri, ServerSocket serverSocket) throws Exception {
        int listenPort = serverSocket.getLocalPort();
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), listenPort, uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public class Acceptor
    implements Runnable {
        private ServerSocket socket;
        private URI target;
        private AtomicReference<CountDownLatch> pause = new AtomicReference();

        public Acceptor(ServerSocket serverSocket, URI uri) {
            this.socket = serverSocket;
            this.target = uri;
            this.pause.set(new CountDownLatch(0));
            try {
                this.socket.setSoTimeout(100);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }

        public void pause() {
            this.pause.set(new CountDownLatch(1));
        }

        public void goOn() {
            this.pause.get().countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.socket.isClosed()) {
                    this.pause.get().await();
                    try {
                        Socket source = this.socket.accept();
                        LOG.info((Object)("accepted " + source + ", receiveBufferSize:" + source.getReceiveBufferSize()));
                        this.pause.get().await();
                        if (SocketProxy.this.receiveBufferSize > 0) {
                            source.setReceiveBufferSize(SocketProxy.this.receiveBufferSize);
                        }
                        LOG.info((Object)("accepted " + source + ", receiveBufferSize:" + source.getReceiveBufferSize()));
                        List<Connection> list = SocketProxy.this.connections;
                        synchronized (list) {
                            SocketProxy.this.connections.add(new Connection(source, this.target));
                        }
                    }
                    catch (SocketTimeoutException expected) {
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("acceptor: finished for reason: " + e.getLocalizedMessage()));
            }
        }

        public void close() {
            try {
                this.socket.close();
                SocketProxy.this.closed.countDown();
                this.goOn();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class Connection {
        private Socket receiveSocket;
        private Socket sendSocket;
        private Pump requestThread;
        private Pump responseThread;

        public Connection(Socket socket, URI target) throws Exception {
            this.receiveSocket = socket;
            this.sendSocket = new Socket();
            if (SocketProxy.this.receiveBufferSize > 0) {
                this.sendSocket.setReceiveBufferSize(SocketProxy.this.receiveBufferSize);
            }
            this.sendSocket.connect(new InetSocketAddress(target.getHost(), target.getPort()));
            this.linkWithThreads(this.receiveSocket, this.sendSocket);
            LOG.info((Object)("proxy connection " + this.sendSocket + ", receiveBufferSize=" + this.sendSocket.getReceiveBufferSize()));
        }

        public void goOn() {
            this.responseThread.goOn();
            this.requestThread.goOn();
        }

        public void pause() {
            this.requestThread.pause();
            this.responseThread.pause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            List<Connection> list = SocketProxy.this.connections;
            synchronized (list) {
                SocketProxy.this.connections.remove(this);
            }
            this.receiveSocket.close();
            this.sendSocket.close();
        }

        private void linkWithThreads(Socket source, Socket dest) {
            this.requestThread = new Pump(source, dest);
            this.responseThread = new Pump(dest, source);
            this.requestThread.start();
            this.responseThread.start();
        }

        public class Pump
        extends Thread {
            protected Socket src;
            private Socket destination;
            private AtomicReference<CountDownLatch> pause;

            public Pump(Socket source, Socket dest) {
                super("SocketProxy-DataTransfer-" + source.getPort() + ":" + dest.getPort());
                this.pause = new AtomicReference();
                this.src = source;
                this.destination = dest;
                this.pause.set(new CountDownLatch(0));
            }

            public void pause() {
                this.pause.set(new CountDownLatch(1));
            }

            public void goOn() {
                this.pause.get().countDown();
            }

            public void run() {
                byte[] buf = new byte[1024];
                try {
                    InputStream in = this.src.getInputStream();
                    OutputStream out = this.destination.getOutputStream();
                    while (true) {
                        int len;
                        if ((len = in.read(buf)) == -1) {
                            LOG.debug((Object)("read eof from:" + this.src));
                            break;
                        }
                        this.pause.get().await();
                        out.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)("read/write failed, reason: " + e.getLocalizedMessage()));
                    try {
                        Connection.this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

