/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

public class Wait {
    public static final long MAX_WAIT_MILLIS = 30000L;

    public static boolean waitFor(Condition condition) throws Exception {
        return Wait.waitFor(condition, 30000L);
    }

    public static boolean waitFor(Condition condition, long duration) throws Exception {
        long expiry = System.currentTimeMillis() + duration;
        boolean conditionSatisified = condition.isSatisified();
        while (!conditionSatisified && System.currentTimeMillis() < expiry) {
            Thread.sleep(1000L);
            conditionSatisified = condition.isSatisified();
        }
        return conditionSatisified;
    }

    public static interface Condition {
        public boolean isSatisified() throws Exception;
    }
}

