/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadb.KahaDBTransactionStore;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaLocalTransactionId;
import org.apache.activemq.store.kahadb.data.KahaLocation;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaXATransactionId;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaDBStore
extends MessageDatabase
implements PersistenceAdapter {
    static final Log LOG = LogFactory.getLog(KahaDBStore.class);
    private static final int MAX_ASYNC_JOBS = 10000;
    public static final String PROPERTY_CANCELED_TASK_MOD_METRIC = "org.apache.activemq.store.kahadb.CANCELED_TASK_MOD_METRIC";
    public static final int cancelledTaskModMetric = Integer.parseInt(System.getProperty("org.apache.activemq.store.kahadb.CANCELED_TASK_MOD_METRIC", "0"), 10);
    public static final String PROPERTY_ASYNC_EXECUTOR_MAX_THREADS = "org.apache.activemq.store.kahadb.ASYNC_EXECUTOR_MAX_THREADS";
    private static final int asyncExecutorMaxThreads = Integer.parseInt(System.getProperty("org.apache.activemq.store.kahadb.ASYNC_EXECUTOR_MAX_THREADS", "1"), 10);
    protected ExecutorService queueExecutor;
    protected ExecutorService topicExecutor;
    protected final List<Map<AsyncJobKey, StoreTask>> asyncQueueMaps = new LinkedList<Map<AsyncJobKey, StoreTask>>();
    protected final List<Map<AsyncJobKey, StoreTask>> asyncTopicMaps = new LinkedList<Map<AsyncJobKey, StoreTask>>();
    final WireFormat wireFormat = new OpenWireFormat();
    private SystemUsage usageManager;
    private LinkedBlockingQueue<Runnable> asyncQueueJobQueue;
    private LinkedBlockingQueue<Runnable> asyncTopicJobQueue;
    Semaphore globalQueueSemaphore;
    Semaphore globalTopicSemaphore;
    private boolean concurrentStoreAndDispatchQueues = true;
    private boolean concurrentStoreAndDispatchTopics = false;
    private boolean concurrentStoreAndDispatchTransactions = false;
    private int maxAsyncJobs = 10000;
    private final KahaDBTransactionStore transactionStore = new KahaDBTransactionStore(this);

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        this.usageManager = usageManager;
    }

    public SystemUsage getUsageManager() {
        return this.usageManager;
    }

    public boolean isConcurrentStoreAndDispatchQueues() {
        return this.concurrentStoreAndDispatchQueues;
    }

    public void setConcurrentStoreAndDispatchQueues(boolean concurrentStoreAndDispatch) {
        this.concurrentStoreAndDispatchQueues = concurrentStoreAndDispatch;
    }

    public boolean isConcurrentStoreAndDispatchTopics() {
        return this.concurrentStoreAndDispatchTopics;
    }

    public void setConcurrentStoreAndDispatchTopics(boolean concurrentStoreAndDispatch) {
        this.concurrentStoreAndDispatchTopics = concurrentStoreAndDispatch;
    }

    public boolean isConcurrentStoreAndDispatchTransactions() {
        return this.concurrentStoreAndDispatchTransactions;
    }

    public int getMaxAsyncJobs() {
        return this.maxAsyncJobs;
    }

    public void setMaxAsyncJobs(int maxAsyncJobs) {
        this.maxAsyncJobs = maxAsyncJobs;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.globalQueueSemaphore = new Semaphore(this.getMaxAsyncJobs());
        this.globalTopicSemaphore = new Semaphore(this.getMaxAsyncJobs());
        this.asyncQueueJobQueue = new LinkedBlockingQueue(this.getMaxAsyncJobs());
        this.asyncTopicJobQueue = new LinkedBlockingQueue(this.getMaxAsyncJobs());
        this.queueExecutor = new ThreadPoolExecutor(1, asyncExecutorMaxThreads, 0L, TimeUnit.MILLISECONDS, this.asyncQueueJobQueue, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "ConcurrentQueueStoreAndDispatch");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.topicExecutor = new ThreadPoolExecutor(1, asyncExecutorMaxThreads, 0L, TimeUnit.MILLISECONDS, this.asyncTopicJobQueue, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "ConcurrentTopicStoreAndDispatch");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        Map<AsyncJobKey, StoreTask> map;
        Map<AsyncJobKey, StoreTask> m;
        Iterator<Map<AsyncJobKey, StoreTask>> i$;
        LOG.info("Stopping async queue tasks");
        if (this.globalQueueSemaphore != null) {
            this.globalQueueSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
        }
        List<Map<AsyncJobKey, StoreTask>> list = this.asyncQueueMaps;
        synchronized (list) {
            i$ = this.asyncQueueMaps.iterator();
            while (i$.hasNext()) {
                map = m = i$.next();
                synchronized (map) {
                    for (StoreTask task : m.values()) {
                        task.cancel();
                    }
                }
            }
            this.asyncQueueMaps.clear();
        }
        LOG.info("Stopping async topic tasks");
        if (this.globalTopicSemaphore != null) {
            this.globalTopicSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
        }
        list = this.asyncTopicMaps;
        synchronized (list) {
            i$ = this.asyncTopicMaps.iterator();
            while (i$.hasNext()) {
                map = m = i$.next();
                synchronized (map) {
                    for (StoreTask task : m.values()) {
                        task.cancel();
                    }
                }
            }
            this.asyncTopicMaps.clear();
        }
        if (this.globalQueueSemaphore != null) {
            this.globalQueueSemaphore.drainPermits();
        }
        if (this.globalTopicSemaphore != null) {
            this.globalTopicSemaphore.drainPermits();
        }
        if (this.queueExecutor != null) {
            this.queueExecutor.shutdownNow();
        }
        if (this.topicExecutor != null) {
            this.topicExecutor.shutdownNow();
        }
        LOG.info("Stopped KahaDB");
        super.doStop(stopper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreQueueTask removeQueueTask(KahaDBMessageStore store, MessageId id) {
        StoreQueueTask task = null;
        Map<AsyncJobKey, StoreTask> map = store.asyncTaskMap;
        synchronized (map) {
            task = (StoreQueueTask)store.asyncTaskMap.remove(new AsyncJobKey(id, store.getDestination()));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addQueueTask(KahaDBMessageStore store, StoreQueueTask task) throws IOException {
        Map<AsyncJobKey, StoreTask> map = store.asyncTaskMap;
        synchronized (map) {
            store.asyncTaskMap.put(new AsyncJobKey(task.getMessage().getMessageId(), store.getDestination()), task);
        }
        this.queueExecutor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreTopicTask removeTopicTask(KahaDBTopicMessageStore store, MessageId id) {
        StoreTopicTask task = null;
        Map map = store.asyncTaskMap;
        synchronized (map) {
            task = (StoreTopicTask)store.asyncTaskMap.remove(new AsyncJobKey(id, store.getDestination()));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTopicTask(KahaDBTopicMessageStore store, StoreTopicTask task) throws IOException {
        Map map = store.asyncTaskMap;
        synchronized (map) {
            store.asyncTaskMap.put(new AsyncJobKey(task.getMessage().getMessageId(), store.getDestination()), task);
        }
        this.topicExecutor.execute(task);
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    public boolean getForceRecoverIndex() {
        return this.forceRecoverIndex;
    }

    public void setForceRecoverIndex(boolean forceRecoverIndex) {
        this.forceRecoverIndex = forceRecoverIndex;
    }

    String subscriptionKey(String clientId, String subscriptionName) {
        return clientId + ":" + subscriptionName;
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        return this.transactionStore.proxy(new KahaDBMessageStore(destination));
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        return this.transactionStore.proxy(new KahaDBTopicMessageStore(destination));
    }

    @Override
    public void removeQueueMessageStore(ActiveMQQueue destination) {
    }

    @Override
    public void removeTopicMessageStore(ActiveMQTopic destination) {
    }

    @Override
    public void deleteAllMessages() throws IOException {
        this.deleteAllMessages = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ActiveMQDestination> getDestinations() {
        try {
            final HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
            this.indexLock.readLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        Iterator<Map.Entry<String, MessageDatabase.StoredDestination>> iterator = KahaDBStore.this.metadata.destinations.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry<String, MessageDatabase.StoredDestination> entry = iterator.next();
                            if (this.isEmptyTopic(entry, tx)) continue;
                            rc.add(KahaDBStore.this.convert(entry.getKey()));
                        }
                    }

                    private boolean isEmptyTopic(Map.Entry<String, MessageDatabase.StoredDestination> entry, Transaction tx) throws IOException {
                        boolean isEmptyTopic = false;
                        ActiveMQDestination dest = KahaDBStore.this.convert(entry.getKey());
                        if (dest.isTopic()) {
                            MessageDatabase.StoredDestination loadedStore = KahaDBStore.this.getStoredDestination(KahaDBStore.this.convert(dest), tx);
                            if (loadedStore.ackPositions.isEmpty()) {
                                isEmptyTopic = true;
                            }
                        }
                        return isEmptyTopic;
                    }
                });
            }
            finally {
                this.indexLock.readLock().unlock();
            }
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastProducerSequenceId(ProducerId id) {
        this.indexLock.readLock().lock();
        try {
            long l = this.metadata.producerSequenceIdTracker.getLastSeqId(id);
            return l;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    @Override
    public long size() {
        return this.storeSize.get();
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        super.checkpointCleanup(false);
    }

    Message loadMessage(Location location) throws IOException {
        KahaAddMessageCommand addMessage = (KahaAddMessageCommand)this.load(location);
        Message msg = (Message)this.wireFormat.unmarshal(new DataInputStream(addMessage.getMessage().newInput()));
        return msg;
    }

    KahaTransactionInfo createTransactionInfo(TransactionId txid) {
        if (txid == null) {
            return null;
        }
        KahaTransactionInfo rc = new KahaTransactionInfo();
        if (txid.isLocalTransaction()) {
            LocalTransactionId t = (LocalTransactionId)txid;
            KahaLocalTransactionId kahaTxId = new KahaLocalTransactionId();
            kahaTxId.setConnectionId(t.getConnectionId().getValue());
            kahaTxId.setTransacitonId(t.getValue());
            rc.setLocalTransacitonId(kahaTxId);
        } else {
            XATransactionId t = (XATransactionId)txid;
            KahaXATransactionId kahaTxId = new KahaXATransactionId();
            kahaTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
            kahaTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
            kahaTxId.setFormatId(t.getFormatId());
            rc.setXaTransacitonId(kahaTxId);
        }
        return rc;
    }

    KahaLocation convert(Location location) {
        KahaLocation rc = new KahaLocation();
        rc.setLogId(location.getDataFileId());
        rc.setOffset(location.getOffset());
        return rc;
    }

    KahaDestination convert(ActiveMQDestination dest) {
        KahaDestination rc = new KahaDestination();
        rc.setName(dest.getPhysicalName());
        switch (dest.getDestinationType()) {
            case 1: {
                rc.setType(KahaDestination.DestinationType.QUEUE);
                return rc;
            }
            case 2: {
                rc.setType(KahaDestination.DestinationType.TOPIC);
                return rc;
            }
            case 5: {
                rc.setType(KahaDestination.DestinationType.TEMP_QUEUE);
                return rc;
            }
            case 6: {
                rc.setType(KahaDestination.DestinationType.TEMP_TOPIC);
                return rc;
            }
        }
        return null;
    }

    ActiveMQDestination convert(String dest) {
        int p = dest.indexOf(":");
        if (p < 0) {
            throw new IllegalArgumentException("Not in the valid destination format");
        }
        int type = Integer.parseInt(dest.substring(0, p));
        String name = dest.substring(p + 1);
        switch (KahaDestination.DestinationType.valueOf(type)) {
            case QUEUE: {
                return new ActiveMQQueue(name);
            }
            case TOPIC: {
                return new ActiveMQTopic(name);
            }
            case TEMP_QUEUE: {
                return new ActiveMQTempQueue(name);
            }
            case TEMP_TOPIC: {
                return new ActiveMQTempTopic(name);
            }
        }
        throw new IllegalArgumentException("Not in the valid destination format");
    }

    class StoreTopicTask
    extends StoreQueueTask {
        private final int subscriptionCount;
        private final List<String> subscriptionKeys;
        private final KahaDBTopicMessageStore topicStore;

        public StoreTopicTask(KahaDBTopicMessageStore store, ConnectionContext context, Message message, int subscriptionCount) {
            super(store, context, message);
            this.subscriptionKeys = new ArrayList<String>(1);
            this.topicStore = store;
            this.subscriptionCount = subscriptionCount;
        }

        void aquireLocks() {
            if (this.locked.compareAndSet(false, true)) {
                try {
                    KahaDBStore.this.globalTopicSemaphore.acquire();
                    this.store.acquireLocalAsyncLock();
                    this.message.incrementReferenceCount();
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to aquire lock", e);
                }
            }
        }

        void releaseLocks() {
            if (this.locked.compareAndSet(true, false)) {
                this.message.decrementReferenceCount();
                this.store.releaseLocalAsyncLock();
                KahaDBStore.this.globalTopicSemaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSubscriptionKey(String key) {
            List<String> list = this.subscriptionKeys;
            synchronized (list) {
                this.subscriptionKeys.add(key);
            }
            return this.subscriptionKeys.size() >= this.subscriptionCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: {
                this.store.doneTasks += 1.0;
                try {
                    if (this.done.compareAndSet(false, true)) {
                        this.topicStore.addMessage(this.context, this.message);
                        List<String> list = this.subscriptionKeys;
                        synchronized (list) {
                            for (String key : this.subscriptionKeys) {
                                this.topicStore.doAcknowledge(this.context, key, this.message.getMessageId(), null);
                            }
                        }
                        KahaDBStore.this.removeTopicTask(this.topicStore, this.message.getMessageId());
                        this.future.complete();
                        break block12;
                    }
                    if (cancelledTaskModMetric > 0) {
                        double d = this.store.canceledTasks;
                        this.store.canceledTasks = d + 1.0;
                        if (d % (double)cancelledTaskModMetric == 0.0) {
                            System.err.println(this.store.dest.getName() + " cancelled: " + this.store.canceledTasks / this.store.doneTasks * 100.0);
                            this.store.doneTasks = 0.0;
                            this.store.canceledTasks = 0.0;
                        }
                    }
                }
                catch (Exception e) {
                    this.future.setException(e);
                }
                finally {
                    this.releaseLocks();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StoreQueueTask
    implements Runnable,
    StoreTask {
        protected final Message message;
        protected final ConnectionContext context;
        protected final KahaDBMessageStore store;
        protected final InnerFutureTask future;
        protected final AtomicBoolean done = new AtomicBoolean();
        protected final AtomicBoolean locked = new AtomicBoolean();

        public StoreQueueTask(KahaDBMessageStore store, ConnectionContext context, Message message) {
            this.store = store;
            this.context = context;
            this.message = message;
            this.future = new InnerFutureTask(this);
        }

        public Future<Object> getFuture() {
            return this.future;
        }

        @Override
        public boolean cancel() {
            this.releaseLocks();
            if (this.done.compareAndSet(false, true)) {
                return this.future.cancel(false);
            }
            return false;
        }

        void aquireLocks() {
            if (this.locked.compareAndSet(false, true)) {
                try {
                    KahaDBStore.this.globalQueueSemaphore.acquire();
                    this.store.acquireLocalAsyncLock();
                    this.message.incrementReferenceCount();
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to aquire lock", e);
                }
            }
        }

        void releaseLocks() {
            if (this.locked.compareAndSet(true, false)) {
                this.store.releaseLocalAsyncLock();
                KahaDBStore.this.globalQueueSemaphore.release();
                this.message.decrementReferenceCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.store.doneTasks += 1.0;
            try {
                if (this.done.compareAndSet(false, true)) {
                    this.store.addMessage(this.context, this.message);
                    KahaDBStore.this.removeQueueTask(this.store, this.message.getMessageId());
                    this.future.complete();
                } else if (cancelledTaskModMetric > 0) {
                    double d = this.store.canceledTasks;
                    this.store.canceledTasks = d + 1.0;
                    if (d % (double)cancelledTaskModMetric == 0.0) {
                        System.err.println(this.store.dest.getName() + " cancelled: " + this.store.canceledTasks / this.store.doneTasks * 100.0);
                        this.store.doneTasks = 0.0;
                        this.store.canceledTasks = 0.0;
                    }
                }
            }
            catch (Exception e) {
                this.future.setException(e);
            }
            finally {
                this.releaseLocks();
            }
        }

        protected Message getMessage() {
            return this.message;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class InnerFutureTask
        extends FutureTask<Object> {
            public InnerFutureTask(Runnable runnable) {
                super(runnable, null);
            }

            public void setException(Exception e) {
                super.setException(e);
            }

            public void complete() {
                super.set(null);
            }
        }
    }

    static interface StoreTask {
        public boolean cancel();
    }

    static class AsyncJobKey {
        MessageId id;
        ActiveMQDestination destination;

        AsyncJobKey(MessageId id, ActiveMQDestination destination) {
            this.id = id;
            this.destination = destination;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof AsyncJobKey && this.id.equals(((AsyncJobKey)obj).id) && this.destination.equals(((AsyncJobKey)obj).destination);
        }

        public int hashCode() {
            return this.id.hashCode() + this.destination.hashCode();
        }

        public String toString() {
            return this.destination.getPhysicalName() + "-" + this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KahaDBTopicMessageStore
    extends KahaDBMessageStore
    implements TopicMessageStore {
        private final AtomicInteger subscriptionCount;

        public KahaDBTopicMessageStore(ActiveMQTopic destination) throws IOException {
            super(destination);
            this.subscriptionCount = new AtomicInteger();
            this.subscriptionCount.set(this.getAllSubscriptions().length);
            KahaDBStore.this.asyncTopicMaps.add(this.asyncTaskMap);
        }

        @Override
        public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
            if (KahaDBStore.this.isConcurrentStoreAndDispatchTopics()) {
                StoreTopicTask result = new StoreTopicTask(this, context, message, this.subscriptionCount.get());
                result.aquireLocks();
                KahaDBStore.this.addTopicTask(this, result);
                return result.getFuture();
            }
            return super.asyncAddTopicMessage(context, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
            String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
            if (KahaDBStore.this.isConcurrentStoreAndDispatchTopics()) {
                AsyncJobKey key = new AsyncJobKey(messageId, this.getDestination());
                StoreTopicTask task = null;
                Map map = this.asyncTaskMap;
                synchronized (map) {
                    task = (StoreTopicTask)this.asyncTaskMap.get(key);
                }
                if (task != null) {
                    if (task.addSubscriptionKey(subscriptionKey)) {
                        KahaDBStore.this.removeTopicTask(this, messageId);
                        if (task.cancel()) {
                            map = this.asyncTaskMap;
                            synchronized (map) {
                                this.asyncTaskMap.remove(key);
                            }
                        }
                    }
                } else {
                    this.doAcknowledge(context, subscriptionKey, messageId, ack);
                }
            } else {
                this.doAcknowledge(context, subscriptionKey, messageId, ack);
            }
        }

        protected void doAcknowledge(ConnectionContext context, String subscriptionKey, MessageId messageId, MessageAck ack) throws IOException {
            KahaRemoveMessageCommand command = new KahaRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(subscriptionKey);
            command.setMessageId(messageId.toString());
            if (ack != null && ack.isUnmatchedAck()) {
                command.setAck(MessageDatabase.UNMATCHED);
            }
            KahaDBStore.this.store(command, false, null, null);
        }

        @Override
        public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
            String subscriptionKey = KahaDBStore.this.subscriptionKey(subscriptionInfo.getClientId(), subscriptionInfo.getSubscriptionName());
            KahaSubscriptionCommand command = new KahaSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(subscriptionKey);
            command.setRetroactive(retroactive);
            ByteSequence packet = KahaDBStore.this.wireFormat.marshal(subscriptionInfo);
            command.setSubscriptionInfo(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            KahaDBStore.this.store(command, KahaDBStore.this.isEnableJournalDiskSyncs(), null, null);
            this.subscriptionCount.incrementAndGet();
        }

        @Override
        public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
            KahaSubscriptionCommand command = new KahaSubscriptionCommand();
            command.setDestination(this.dest);
            command.setSubscriptionKey(KahaDBStore.this.subscriptionKey(clientId, subscriptionName));
            KahaDBStore.this.store(command, KahaDBStore.this.isEnableJournalDiskSyncs(), null, null);
            this.subscriptionCount.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionInfo[] getAllSubscriptions() throws IOException {
            final ArrayList subscriptions = new ArrayList();
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                        Iterator<Map.Entry<String, KahaSubscriptionCommand>> iterator = sd.subscriptions.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry<String, KahaSubscriptionCommand> entry = iterator.next();
                            SubscriptionInfo info = (SubscriptionInfo)KahaDBStore.this.wireFormat.unmarshal(new DataInputStream(entry.getValue().getSubscriptionInfo().newInput()));
                            subscriptions.add(info);
                        }
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
            SubscriptionInfo[] rc = new SubscriptionInfo[subscriptions.size()];
            subscriptions.toArray(rc);
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                SubscriptionInfo subscriptionInfo = KahaDBStore.this.pageFile.tx().execute(new Transaction.CallableClosure<SubscriptionInfo, IOException>(){

                    @Override
                    public SubscriptionInfo execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                        KahaSubscriptionCommand command = sd.subscriptions.get(tx, subscriptionKey);
                        if (command == null) {
                            return null;
                        }
                        return (SubscriptionInfo)KahaDBStore.this.wireFormat.unmarshal(new DataInputStream(command.getSubscriptionInfo().newInput()));
                    }
                });
                return subscriptionInfo;
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
        }

        protected Long resetForSelectors(SubscriptionInfo info, Long position) {
            if (info.getSelector() != null && position < -1L) {
                position = -1L;
            }
            return position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMessageCount(String clientId, String subscriptionName) throws IOException {
            final String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
            final SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            KahaDBStore.this.indexLock.writeLock().lock();
            try {
                int n = KahaDBStore.this.pageFile.tx().execute(new Transaction.CallableClosure<Integer, IOException>(){

                    @Override
                    public Integer execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                        Long cursorPos = sd.subscriptionAcks.get(tx, subscriptionKey);
                        if (cursorPos == null) {
                            return 0;
                        }
                        cursorPos = KahaDBTopicMessageStore.this.resetForSelectors(info, cursorPos);
                        int counter = 0;
                        try {
                            String selector = info.getSelector();
                            BooleanExpression selectorExpression = null;
                            if (selector != null) {
                                selectorExpression = SelectorParser.parse(selector);
                            }
                            sd.orderIndex.resetCursorPosition();
                            sd.orderIndex.setBatch(tx, KahaDBStore.this.extractSequenceId(cursorPos));
                            Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                            while (iterator.hasNext()) {
                                Map.Entry<Long, MessageDatabase.MessageKeys> entry = iterator.next();
                                if (selectorExpression != null) {
                                    MessageEvaluationContext ctx = new MessageEvaluationContext();
                                    ctx.setMessageReference(KahaDBStore.this.loadMessage(entry.getValue().location));
                                    if (!selectorExpression.matches(ctx)) continue;
                                    ++counter;
                                    continue;
                                }
                                ++counter;
                            }
                            sd.orderIndex.resetCursorPosition();
                        }
                        catch (Exception e) {
                            throw IOExceptionSupport.create(e);
                        }
                        return counter;
                    }
                });
                return n;
            }
            finally {
                KahaDBStore.this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
            final SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            KahaDBStore.this.indexLock.writeLock().lock();
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<Exception>(){

                    @Override
                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                        Long cursorPos = sd.subscriptionAcks.get(tx, subscriptionKey);
                        cursorPos = KahaDBTopicMessageStore.this.resetForSelectors(info, cursorPos);
                        sd.orderIndex.setBatch(tx, KahaDBStore.this.extractSequenceId(cursorPos));
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry<Long, MessageDatabase.MessageKeys> entry = iterator.next();
                            listener.recoverMessage(KahaDBStore.this.loadMessage(entry.getValue().location));
                        }
                        sd.orderIndex.resetCursorPosition();
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverNextMessages(String clientId, String subscriptionName, final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            final String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
            final SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            KahaDBStore.this.indexLock.writeLock().lock();
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<Exception>(){

                    @Override
                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                        sd.orderIndex.resetCursorPosition();
                        MessageDatabase.MessageOrderCursor moc = sd.subscriptionCursors.get(subscriptionKey);
                        if (moc == null) {
                            Long pos = sd.subscriptionAcks.get(tx, subscriptionKey);
                            pos = KahaDBTopicMessageStore.this.resetForSelectors(info, pos);
                            sd.orderIndex.setBatch(tx, KahaDBStore.this.extractSequenceId(pos));
                            moc = sd.orderIndex.cursor;
                        } else {
                            sd.orderIndex.cursor.sync(moc);
                        }
                        Map.Entry<Long, MessageDatabase.MessageKeys> entry = null;
                        int counter = 0;
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx, moc);
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            if (listener.recoverMessage(KahaDBStore.this.loadMessage(entry.getValue().location))) {
                                ++counter;
                            }
                            if (counter < maxReturned && listener.hasSpace()) continue;
                        }
                        sd.orderIndex.stoppedIterating();
                        if (entry != null) {
                            MessageDatabase.MessageOrderCursor copy = sd.orderIndex.cursor.copy();
                            sd.subscriptionCursors.put(subscriptionKey, copy);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("updated moc: " + copy + ", recovered: " + counter);
                            }
                        }
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetBatching(String clientId, String subscriptionName) {
            try {
                final String subscriptionKey = KahaDBStore.this.subscriptionKey(clientId, subscriptionName);
                KahaDBStore.this.indexLock.writeLock().lock();
                try {
                    KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBTopicMessageStore.this.dest, tx);
                            sd.subscriptionCursors.remove(subscriptionKey);
                        }
                    });
                }
                finally {
                    KahaDBStore.this.indexLock.writeLock().unlock();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KahaDBMessageStore
    extends AbstractMessageStore {
        protected final Map<AsyncJobKey, StoreTask> asyncTaskMap;
        protected KahaDestination dest;
        private final int maxAsyncJobs;
        private final Semaphore localDestinationSemaphore;
        double doneTasks;
        double canceledTasks;

        public KahaDBMessageStore(ActiveMQDestination destination) {
            super(destination);
            this.asyncTaskMap = new HashMap<AsyncJobKey, StoreTask>();
            this.canceledTasks = 0.0;
            this.dest = KahaDBStore.this.convert(destination);
            this.maxAsyncJobs = KahaDBStore.this.getMaxAsyncJobs();
            this.localDestinationSemaphore = new Semaphore(this.maxAsyncJobs);
        }

        @Override
        public ActiveMQDestination getDestination() {
            return this.destination;
        }

        @Override
        public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
            if (KahaDBStore.this.isConcurrentStoreAndDispatchQueues()) {
                StoreQueueTask result = new StoreQueueTask(this, context, message);
                result.aquireLocks();
                KahaDBStore.this.addQueueTask(this, result);
                return result.getFuture();
            }
            return super.asyncAddQueueMessage(context, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
            if (KahaDBStore.this.isConcurrentStoreAndDispatchQueues()) {
                AsyncJobKey key = new AsyncJobKey(ack.getLastMessageId(), this.getDestination());
                StoreQueueTask task = null;
                Map<AsyncJobKey, StoreTask> map = this.asyncTaskMap;
                synchronized (map) {
                    task = (StoreQueueTask)this.asyncTaskMap.get(key);
                }
                if (task != null) {
                    if (!task.cancel()) {
                        try {
                            task.future.get();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException(e.toString());
                        }
                        catch (Exception ignored) {
                            LOG.debug("removeAsync: cannot cancel, waiting for add resulted in ex", ignored);
                        }
                        this.removeMessage(context, ack);
                        return;
                    }
                    map = this.asyncTaskMap;
                    synchronized (map) {
                        this.asyncTaskMap.remove(key);
                        return;
                    }
                }
                this.removeMessage(context, ack);
                return;
            }
            this.removeMessage(context, ack);
        }

        @Override
        public void addMessage(ConnectionContext context, Message message) throws IOException {
            KahaAddMessageCommand command = new KahaAddMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(message.getMessageId().toString());
            command.setTransactionInfo(KahaDBStore.this.createTransactionInfo(message.getTransactionId()));
            command.setPriority(message.getPriority());
            command.setPrioritySupported(this.isPrioritizedMessages());
            ByteSequence packet = KahaDBStore.this.wireFormat.marshal(message);
            command.setMessage(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            KahaDBStore.this.store(command, KahaDBStore.this.isEnableJournalDiskSyncs() && message.isResponseRequired(), null, null);
        }

        @Override
        public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
            KahaRemoveMessageCommand command = new KahaRemoveMessageCommand();
            command.setDestination(this.dest);
            command.setMessageId(ack.getLastMessageId().toString());
            command.setTransactionInfo(KahaDBStore.this.createTransactionInfo(ack.getTransactionId()));
            ByteSequence packet = KahaDBStore.this.wireFormat.marshal(ack);
            command.setAck(new Buffer(packet.getData(), packet.getOffset(), packet.getLength()));
            KahaDBStore.this.store(command, KahaDBStore.this.isEnableJournalDiskSyncs() && ack.isResponseRequired(), null, null);
        }

        @Override
        public void removeAllMessages(ConnectionContext context) throws IOException {
            KahaRemoveDestinationCommand command = new KahaRemoveDestinationCommand();
            command.setDestination(this.dest);
            KahaDBStore.this.store(command, true, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message getMessage(MessageId identity) throws IOException {
            Location location;
            final String key = identity.toString();
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                location = KahaDBStore.this.pageFile.tx().execute(new Transaction.CallableClosure<Location, IOException>(){

                    @Override
                    public Location execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                        Long sequence = sd.messageIdIndex.get(tx, key);
                        if (sequence == null) {
                            return null;
                        }
                        return sd.orderIndex.get((Transaction)tx, (Long)sequence).location;
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
            if (location == null) {
                return null;
            }
            return KahaDBStore.this.loadMessage(location);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMessageCount() throws IOException {
            try {
                this.lockAsyncJobQueue();
                KahaDBStore.this.indexLock.readLock().lock();
                try {
                    int n = KahaDBStore.this.pageFile.tx().execute(new Transaction.CallableClosure<Integer, IOException>(){

                        @Override
                        public Integer execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                            int rc = 0;
                            Iterator<Map.Entry<Location, Long>> iterator = sd.locationIndex.iterator(tx);
                            while (iterator.hasNext()) {
                                iterator.next();
                                ++rc;
                            }
                            return rc;
                        }
                    });
                    KahaDBStore.this.indexLock.readLock().unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    KahaDBStore.this.indexLock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                this.unlockAsyncJobQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() throws IOException {
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                boolean bl = KahaDBStore.this.pageFile.tx().execute(new Transaction.CallableClosure<Boolean, IOException>(){

                    @Override
                    public Boolean execute(Transaction tx) throws IOException {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                        return sd.locationIndex.isEmpty(tx);
                    }
                });
                return bl;
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recover(final MessageRecoveryListener listener) throws Exception {
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<Exception>(){

                    @Override
                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                        sd.orderIndex.resetCursorPosition();
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (iterator.hasNext()) {
                            Map.Entry<Long, MessageDatabase.MessageKeys> entry = iterator.next();
                            Message msg = KahaDBStore.this.loadMessage(entry.getValue().location);
                            listener.recoverMessage(msg);
                        }
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverNextMessages(final int maxReturned, final MessageRecoveryListener listener) throws Exception {
            KahaDBStore.this.indexLock.readLock().lock();
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<Exception>(){

                    @Override
                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                        Map.Entry<Long, MessageDatabase.MessageKeys> entry = null;
                        int counter = 0;
                        Iterator<Map.Entry<Long, MessageDatabase.MessageKeys>> iterator = sd.orderIndex.iterator(tx);
                        while (iterator.hasNext() && listener.hasSpace()) {
                            entry = iterator.next();
                            Message msg = KahaDBStore.this.loadMessage(entry.getValue().location);
                            listener.recoverMessage(msg);
                            if (++counter < maxReturned && listener.hasSpace()) continue;
                            break;
                        }
                        sd.orderIndex.stoppedIterating();
                    }
                });
            }
            finally {
                KahaDBStore.this.indexLock.readLock().unlock();
            }
        }

        @Override
        public void resetBatching() {
            try {
                KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<Exception>(){

                    @Override
                    public void execute(Transaction tx) throws Exception {
                        MessageDatabase.StoredDestination sd = KahaDBStore.this.getExistingStoredDestination(KahaDBMessageStore.this.dest, tx);
                        if (sd != null) {
                            sd.orderIndex.resetCursorPosition();
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to reset batching", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBatch(MessageId identity) throws IOException {
            try {
                final String key = identity.toString();
                this.lockAsyncJobQueue();
                KahaDBStore.this.indexLock.readLock().lock();
                try {
                    KahaDBStore.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            MessageDatabase.StoredDestination sd = KahaDBStore.this.getStoredDestination(KahaDBMessageStore.this.dest, tx);
                            Long location = sd.messageIdIndex.get(tx, key);
                            if (location != null) {
                                sd.orderIndex.setBatch(tx, location);
                            }
                        }
                    });
                }
                finally {
                    KahaDBStore.this.indexLock.readLock().unlock();
                }
            }
            finally {
                this.unlockAsyncJobQueue();
            }
        }

        @Override
        public void setMemoryUsage(MemoryUsage memoeyUSage) {
        }

        @Override
        public void start() throws Exception {
            super.start();
        }

        @Override
        public void stop() throws Exception {
            super.stop();
        }

        protected void lockAsyncJobQueue() {
            try {
                this.localDestinationSemaphore.tryAcquire(this.maxAsyncJobs, 60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Failed to lock async jobs for " + this.destination, e);
            }
        }

        protected void unlockAsyncJobQueue() {
            this.localDestinationSemaphore.release(this.maxAsyncJobs);
        }

        protected void acquireLocalAsyncLock() {
            try {
                this.localDestinationSemaphore.acquire();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to aquire async lock for " + this.destination, e);
            }
        }

        protected void releaseLocalAsyncLock() {
            this.localDestinationSemaphore.release();
        }
    }
}

