/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.HistoryListener;
import java.util.ArrayList;

public abstract class HistoryImpl {
    private static ArrayList<HistoryListener> historyListeners = new ArrayList();

    public static void addHistoryListener(HistoryListener listener) {
        historyListeners.add(listener);
    }

    public static native String getToken();

    public static void removeHistoryListener(HistoryListener listener) {
        historyListeners.remove(listener);
    }

    protected static native void setToken(String var0);

    private static void fireHistoryChanged(String historyToken) {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            HistoryImpl.fireHistoryChangedAndCatch(historyToken, handler);
        } else {
            HistoryImpl.fireHistoryChangedImpl(historyToken);
        }
    }

    private static void fireHistoryChangedAndCatch(String historyToken, GWT.UncaughtExceptionHandler handler) {
        try {
            HistoryImpl.fireHistoryChangedImpl(historyToken);
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireHistoryChangedImpl(String historyToken) {
        HistoryListener[] listenersToInvoke;
        for (HistoryListener listener : listenersToInvoke = historyListeners.toArray(new HistoryListener[historyListeners.size()])) {
            listener.onHistoryChanged(historyToken);
        }
    }

    public abstract boolean init();

    public final void newItem(String historyToken, boolean issueEvent) {
        String string = historyToken = historyToken == null ? "" : historyToken;
        if (!historyToken.equals(HistoryImpl.getToken())) {
            HistoryImpl.setToken(historyToken);
            this.nativeUpdate(historyToken);
            if (issueEvent) {
                HistoryImpl.fireHistoryChangedImpl(historyToken);
            }
        }
    }

    public final void newItemOnEvent(String historyToken) {
        String string = historyToken = historyToken == null ? "" : historyToken;
        if (!historyToken.equals(HistoryImpl.getToken())) {
            HistoryImpl.setToken(historyToken);
            this.nativeUpdateOnEvent(historyToken);
            HistoryImpl.fireHistoryChanged(historyToken);
        }
    }

    protected native String decodeFragment(String var1);

    protected native String encodeFragment(String var1);

    protected abstract void nativeUpdate(String var1);

    protected abstract void nativeUpdateOnEvent(String var1);
}

