/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusListenerCollection;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.MouseWheelListenerCollection;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.SourcesMouseWheelEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;

public class FocusPanel
extends SimplePanel
implements HasFocus,
SourcesClickEvents,
SourcesMouseEvents,
SourcesMouseWheelEvents {
    static final FocusImpl impl = FocusImpl.getFocusImplForPanel();
    private ClickListenerCollection clickListeners;
    private FocusListenerCollection focusListeners;
    private KeyboardListenerCollection keyboardListeners;
    private MouseListenerCollection mouseListeners;
    private MouseWheelListenerCollection mouseWheelListeners;

    public FocusPanel() {
        super(impl.createFocusable());
        this.sinkEvents(138237);
    }

    public FocusPanel(Widget child) {
        this();
        this.setWidget(child);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new FocusListenerCollection();
        }
        this.focusListeners.add(listener);
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new KeyboardListenerCollection();
        }
        this.keyboardListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = new MouseWheelListenerCollection();
        }
        this.mouseWheelListeners.add(listener);
    }

    public int getTabIndex() {
        return impl.getTabIndex(this.getElement());
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 131072: {
                if (this.mouseWheelListeners == null) break;
                this.mouseWheelListeners.fireMouseWheelEvent(this, event);
                break;
            }
            case 2048: 
            case 4096: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 128: 
            case 256: 
            case 512: {
                if (this.keyboardListeners == null) break;
                this.keyboardListeners.fireKeyboardEvent(this, event);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners != null) {
            this.mouseWheelListeners.remove(listener);
        }
    }

    public void setAccessKey(char key) {
        impl.setAccessKey(this.getElement(), key);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            impl.focus(this.getElement());
        } else {
            impl.blur(this.getElement());
        }
    }

    public void setTabIndex(int index) {
        impl.setTabIndex(this.getElement(), index);
    }
}

