/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsConsumerResetActiveListenerTest
extends TestCase {
    private Connection connection;
    private ActiveMQConnectionFactory factory;

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = this.factory.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void testSetListenerFromListener() throws Exception {
        Session session = this.connection.createSession(false, 2);
        Queue dest = session.createQueue("Queue-" + this.getName());
        final MessageConsumer consumer = session.createConsumer((Destination)dest);
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean first = new AtomicBoolean(true);
        final Vector results = new Vector();
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                if (first.compareAndSet(true, false)) {
                    try {
                        consumer.setMessageListener((MessageListener)this);
                        results.add(message);
                    }
                    catch (JMSException e) {
                        results.add(e);
                    }
                } else {
                    results.add(message);
                }
                latch.countDown();
            }
        });
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        JmsConsumerResetActiveListenerTest.assertTrue((String)"we did not timeout", (boolean)latch.await(5L, TimeUnit.SECONDS));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"we have a result", (int)2, (int)results.size());
        Object result = results.get(0);
        JmsConsumerResetActiveListenerTest.assertTrue((boolean)(result instanceof TextMessage));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"result is first", (String)"First", (String)((TextMessage)result).getText());
        result = results.get(1);
        JmsConsumerResetActiveListenerTest.assertTrue((boolean)(result instanceof TextMessage));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"result is first", (String)"Second", (String)((TextMessage)result).getText());
    }

    public void testNewConsumerSetListenerFromListener() throws Exception {
        final Session session = this.connection.createSession(false, 2);
        Queue dest = session.createQueue("Queue-" + this.getName());
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean first = new AtomicBoolean(true);
        Vector results = new Vector();
        consumer.setMessageListener(new MessageListener((Destination)dest, results, latch){
            final /* synthetic */ Destination val$dest;
            final /* synthetic */ Vector val$results;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dest = destination;
                this.val$results = vector;
                this.val$latch = countDownLatch;
            }

            public void onMessage(Message message) {
                if (first.compareAndSet(true, false)) {
                    try {
                        MessageConsumer anotherConsumer = session.createConsumer(this.val$dest);
                        anotherConsumer.setMessageListener((MessageListener)this);
                        this.val$results.add(message);
                    }
                    catch (JMSException e) {
                        this.val$results.add(e);
                    }
                } else {
                    this.val$results.add(message);
                }
                this.val$latch.countDown();
            }
        });
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        JmsConsumerResetActiveListenerTest.assertTrue((String)"we did not timeout", (boolean)latch.await(5L, TimeUnit.SECONDS));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"we have a result", (int)2, (int)results.size());
        Object result = results.get(0);
        JmsConsumerResetActiveListenerTest.assertTrue((boolean)(result instanceof TextMessage));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"result is first", (String)"First", (String)((TextMessage)result).getText());
        result = results.get(1);
        JmsConsumerResetActiveListenerTest.assertTrue((boolean)(result instanceof TextMessage));
        JmsConsumerResetActiveListenerTest.assertEquals((String)"result is first", (String)"Second", (String)((TextMessage)result).getText());
    }
}

