/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueBrowserTest
extends JmsTestSupport {
    private static final Log LOG = LogFactory.getLog(JmsQueueBrowserTest.class);

    public void testReceiveBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        while (consumer.receive(1000L) != null) {
        }
        producer.send(outbound[0]);
        producer.send(outbound[1]);
        producer.send(outbound[2]);
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertTrue((String)"should have received the second message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], (Object)((Message)enumeration.nextElement()));
        JmsQueueBrowserTest.assertTrue((String)"Should have received the third message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], (Object)((Message)enumeration.nextElement()));
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            LOG.info((Object)("Got extra message: " + ((TextMessage)enumeration.nextElement()).getText()));
            tooMany = true;
        }
        JmsQueueBrowserTest.assertFalse((boolean)tooMany);
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], (Object)consumer.receive(1000L));
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], (Object)consumer.receive(1000L));
        consumer.close();
    }

    public void testBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send(outbound[0]);
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        JmsQueueBrowserTest.assertTrue((String)"should have received the first message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)((Message)enumeration.nextElement()));
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        browser.close();
        producer.close();
    }

    public void testQueueBrowserWith2Consumers() throws Exception {
        Message m1;
        int i;
        int numMessages = 1000;
        this.connection.setAlwaysSyncSend(false);
        Session session = this.connection.createSession(false, 2);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        ActiveMQQueue destinationPrefetch10 = new ActiveMQQueue("TEST?jms.prefetchSize=10");
        ActiveMQQueue destinationPrefetch1 = new ActiveMQQueue("TEST?jms.prefetchsize=1");
        this.connection.start();
        ActiveMQConnection connection2 = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
        connection2.start();
        this.connections.add(connection2);
        Session session2 = connection2.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destinationPrefetch10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            TextMessage message = session.createTextMessage("Message: " + i2);
            producer.send((Message)message);
        }
        QueueBrowser browser = session2.createBrowser((Queue)destinationPrefetch1);
        Enumeration browserView = browser.getEnumeration();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (i = 0; i < 1000; ++i) {
            m1 = consumer.receive(5000L);
            JmsQueueBrowserTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            messages.add(m1);
        }
        for (i = 0; i < 1000 && browserView.hasMoreElements(); ++i) {
            m1 = (Message)messages.get(i);
            Message m2 = (Message)browserView.nextElement();
            JmsQueueBrowserTest.assertNotNull((String)("m2 is null for index: " + i), (Object)m2);
            JmsQueueBrowserTest.assertEquals((String)m1.getJMSMessageID(), (String)m2.getJMSMessageID());
        }
        JmsQueueBrowserTest.assertTrue((String)"got at least our expected minimum in the browser: ", (i > 200 ? 1 : 0) != 0);
        JmsQueueBrowserTest.assertFalse((String)"nothing left in the browser", (boolean)browserView.hasMoreElements());
        JmsQueueBrowserTest.assertNull((String)"consumer finished", (Object)consumer.receiveNoWait());
    }
}

