/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnePrefetchAsyncConsumerTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(OnePrefetchAsyncConsumerTest.class);
    private TestMutex testMutex;
    protected Connection connection;
    protected ConnectionConsumer connectionConsumer;
    protected Queue queue;
    protected CountDownLatch messageTwoDelay = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrefetchExtension() throws Exception {
        Session session = this.connection.createSession(true, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        producer.send((Message)session.createTextMessage("Msg3"));
        session.commit();
        TestMutex testMutex = this.testMutex;
        synchronized (testMutex) {
            while (!this.testMutex.testCompleted) {
                this.testMutex.wait();
            }
        }
        OnePrefetchAsyncConsumerTest.assertTrue((String)"Attempted to retrieve more than one ServerSession at a time", (boolean)this.testMutex.testSuccessful);
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
        this.testMutex = new TestMutex();
        this.connection = this.createConnection();
        this.queue = this.createQueue();
        this.connectionConsumer = this.connection.createConnectionConsumer((Destination)this.queue, null, (ServerSessionPool)new TestServerSessionPool(this.connection), 1);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connectionConsumer.close();
        this.connection.close();
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = super.createBroker();
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setUsePrefetchExtension(false);
        policyMap.setDefaultEntry(defaultEntry);
        answer.setDestinationPolicy(policyMap);
        return answer;
    }

    protected Queue createQueue() {
        return new ActiveMQQueue(this.getDestinationString());
    }

    private class TestMutex {
        boolean testCompleted = false;
        boolean testSuccessful = true;

        private TestMutex() {
        }
    }

    private class TestMessageListener
    implements MessageListener {
        private TestMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            block9: {
                try {
                    String text = ((TextMessage)message).getText();
                    LOG.info((Object)("got message: " + text));
                    if (text.equals("Msg3")) {
                        TestMutex testMutex = OnePrefetchAsyncConsumerTest.this.testMutex;
                        synchronized (testMutex) {
                            if (!((OnePrefetchAsyncConsumerTest)OnePrefetchAsyncConsumerTest.this).testMutex.testCompleted) {
                                ((OnePrefetchAsyncConsumerTest)OnePrefetchAsyncConsumerTest.this).testMutex.testSuccessful = true;
                                ((OnePrefetchAsyncConsumerTest)OnePrefetchAsyncConsumerTest.this).testMutex.testCompleted = true;
                            }
                            break block9;
                        }
                    }
                    if (text.equals("Msg2")) {
                        TimeUnit.SECONDS.sleep(4L);
                    }
                }
                catch (JMSException e) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class TestServerSession
    implements ServerSession {
        TestServerSessionPool pool;
        Session session;

        public TestServerSession(TestServerSessionPool pool) throws JMSException {
            this.pool = pool;
            this.session = pool.connection.createSession(true, 1);
            this.session.setMessageListener((MessageListener)new TestMessageListener());
        }

        public Session getSession() throws JMSException {
            return this.session;
        }

        public void start() throws JMSException {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TestServerSession.this.session.run();
                    try {
                        TestServerSession.this.session.commit();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    Object object = TestServerSession.this.pool;
                    synchronized (object) {
                        TestServerSession.this.pool.serverSessionInUse = false;
                    }
                    object = OnePrefetchAsyncConsumerTest.this.testMutex;
                    synchronized (object) {
                        OnePrefetchAsyncConsumerTest.this.testMutex.notify();
                    }
                }
            }.start();
        }
    }

    private class TestServerSessionPool
    implements ServerSessionPool {
        Connection connection;
        TestServerSession serverSession;
        boolean serverSessionInUse = false;

        public TestServerSessionPool(Connection connection) throws JMSException {
            this.connection = connection;
            this.serverSession = new TestServerSession(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerSession getServerSession() throws JMSException {
            TestServerSessionPool testServerSessionPool = this;
            synchronized (testServerSessionPool) {
                if (this.serverSessionInUse) {
                    LOG.info((Object)"asked for session while in use, not serialised delivery");
                    TestMutex testMutex = OnePrefetchAsyncConsumerTest.this.testMutex;
                    synchronized (testMutex) {
                        ((OnePrefetchAsyncConsumerTest)OnePrefetchAsyncConsumerTest.this).testMutex.testSuccessful = false;
                        ((OnePrefetchAsyncConsumerTest)OnePrefetchAsyncConsumerTest.this).testMutex.testCompleted = true;
                    }
                }
                this.serverSessionInUse = true;
                return this.serverSession;
            }
        }
    }
}

