/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;

public class RemoveDestinationTest
extends TestCase {
    private static final String VM_BROKER_URL = "vm://localhost?create=false";
    private static final String BROKER_URL = "broker:vm://localhost?broker.persistent=false&broker.useJmx=true";
    BrokerService broker;

    public RemoveDestinationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = BrokerFactory.createBroker((URI)new URI(BROKER_URL));
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    public void testRemoveDestinationWithoutSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        RemoveDestinationTest.assertNotNull((Object)consumer.receive(5000L));
        Thread.sleep(1000L);
        ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        RemoveDestinationTest.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        consumer.close();
        producer.close();
        session.close();
        Thread.sleep(3000L);
        amqConnection.destroyDestination((ActiveMQDestination)topic);
        Thread.sleep(3000L);
        RemoveDestinationTest.assertFalse((boolean)destinationSource.getTopics().contains(amqTopic));
    }

    public void testRemoveDestinationWithSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        RemoveDestinationTest.assertNotNull((Object)consumer.receive(5000L));
        Thread.sleep(1000L);
        ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        RemoveDestinationTest.assertTrue((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
        RemoveDestinationTest.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        try {
            amqConnection.destroyDestination((ActiveMQDestination)topic);
            RemoveDestinationTest.fail((String)"expect exception on destroy if comsumer present");
        }
        catch (JMSException expected) {
            RemoveDestinationTest.assertTrue((expected.getMessage().indexOf(amqTopic.getTopicName()) != -1 ? 1 : 0) != 0);
        }
        Thread.sleep(3000L);
        RemoveDestinationTest.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        RemoveDestinationTest.assertTrue((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
        consumer.close();
        producer.close();
        session.close();
        Thread.sleep(3000L);
        amqConnection.destroyDestination((ActiveMQDestination)amqTopic);
        Thread.sleep(3000L);
        RemoveDestinationTest.assertFalse((boolean)destinationSource.getTopics().contains(amqTopic));
        RemoveDestinationTest.assertFalse((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
    }

    private boolean destinationPresentInAdminView(BrokerService broker2, ActiveMQTopic amqTopic) throws Exception {
        boolean found = false;
        for (ObjectName name : this.broker.getAdminView().getTopics()) {
            if (name.getKeyProperty("Destination") == null || !name.getKeyProperty("Destination").equalsIgnoreCase(amqTopic.getTopicName())) continue;
            found = true;
            break;
        }
        return found;
    }
}

