/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.spring.SpringConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZeroPrefetchConsumerTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(ZeroPrefetchConsumerTest.class);
    protected Connection connection;
    protected Queue queue;

    public void testCannotUseMessageListener() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        SpringConsumer listener = new SpringConsumer();
        try {
            consumer.setMessageListener((MessageListener)listener);
            ZeroPrefetchConsumerTest.fail((String)"Should have thrown JMSException as we cannot use MessageListener with zero prefetch");
        }
        catch (JMSException e) {
            LOG.info((Object)("Received expected exception : " + (Object)((Object)e)));
        }
    }

    public void testPullConsumerWorks() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Hello World!"));
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        Message answer = consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertNotNull((String)"Should have received a message!", (Object)answer);
        answer = consumer.receive(1L);
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
        answer = consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testIdleConsumer() throws Exception {
        this.doTestIdleConsumer(false);
    }

    public void testIdleConsumerTranscated() throws Exception {
        this.doTestIdleConsumer(true);
    }

    private void doTestIdleConsumer(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        session.createConsumer((Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testRecvRecvCommit() throws Exception {
        this.doTestRecvRecvCommit(false);
    }

    public void testRecvRecvCommitTranscated() throws Exception {
        this.doTestRecvRecvCommit(true);
    }

    private void doTestRecvRecvCommit(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testTwoConsumers() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        TextMessage answer = (TextMessage)consumer1.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        answer = (TextMessage)consumer2.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        answer = (TextMessage)consumer2.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testManyMessageConsumer() throws Exception {
        this.doTestManyMessageConsumer(true);
    }

    public void testManyMessageConsumerNoTransaction() throws Exception {
        this.doTestManyMessageConsumer(false);
    }

    private void doTestManyMessageConsumer(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        producer.send((Message)session.createTextMessage("Msg3"));
        producer.send((Message)session.createTextMessage("Msg4"));
        producer.send((Message)session.createTextMessage("Msg5"));
        producer.send((Message)session.createTextMessage("Msg6"));
        producer.send((Message)session.createTextMessage("Msg7"));
        producer.send((Message)session.createTextMessage("Msg8"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg3");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg4");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg5");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg6");
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg7");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg8");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testManyMessageConsumerWithSend() throws Exception {
        this.doTestManyMessageConsumerWithSend(true);
    }

    public void testManyMessageConsumerWithSendNoTransaction() throws Exception {
        this.doTestManyMessageConsumerWithSend(false);
    }

    private void doTestManyMessageConsumerWithSend(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        producer.send((Message)session.createTextMessage("Msg3"));
        producer.send((Message)session.createTextMessage("Msg4"));
        producer.send((Message)session.createTextMessage("Msg5"));
        producer.send((Message)session.createTextMessage("Msg6"));
        producer.send((Message)session.createTextMessage("Msg7"));
        producer.send((Message)session.createTextMessage("Msg8"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg3");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg4");
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg5");
        producer.send((Message)session.createTextMessage("Msg9"));
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg6");
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg7");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg8");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg9");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.queue = this.createQueue();
    }

    protected void startBroker() throws Exception {
        super.startBroker();
        this.bindAddress = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    protected Queue createQueue() {
        return new ActiveMQQueue(this.getDestinationString() + "?consumer.prefetchSize=0");
    }
}

