/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.blob.FTPTestSupport;
import org.apache.activemq.command.ActiveMQBlobMessage;

public class FTPBlobTest
extends FTPTestSupport {
    public void testBlobFile() throws Exception {
        this.setConnection();
        File file = File.createTempFile("amq-data-file-", ".dat");
        String content = "hello world " + System.currentTimeMillis();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append(content);
        writer.close();
        ActiveMQSession session = (ActiveMQSession)this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        BlobMessage message = session.createBlobMessage(file);
        producer.send((Message)message);
        Thread.sleep(1000L);
        Message msg = consumer.receive(1000L);
        Assert.assertTrue((boolean)(msg instanceof ActiveMQBlobMessage));
        InputStream input = ((ActiveMQBlobMessage)msg).getInputStream();
        StringBuilder b = new StringBuilder();
        int i = input.read();
        while (i != -1) {
            b.append((char)i);
            i = input.read();
        }
        input.close();
        File uploaded = new File(this.ftpHomeDirFile, msg.getJMSMessageID().toString().replace(":", "_"));
        Assert.assertEquals((String)content, (String)b.toString());
        FTPBlobTest.assertTrue((boolean)uploaded.exists());
        ((ActiveMQBlobMessage)msg).deleteFile();
        FTPBlobTest.assertFalse((boolean)uploaded.exists());
    }
}

