/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.blob.FTPTestSupport;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.MessageId;

public class FTPBlobUploadStrategyTest
extends FTPTestSupport {
    public void testFileUpload() throws Exception {
        this.setConnection();
        File file = File.createTempFile("amq-data-file-", ".dat");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append("hello world");
        writer.close();
        Session session = this.connection.createSession(false, 1);
        ((ActiveMQConnection)this.connection).setCopyMessageOnSend(false);
        ActiveMQBlobMessage message = (ActiveMQBlobMessage)((ActiveMQSession)session).createBlobMessage(file);
        message.setMessageId(new MessageId("testmessage"));
        message.onSend();
        Assert.assertEquals((String)(this.ftpUrl + "testmessage"), (String)message.getURL().toString());
        File uploaded = new File(this.ftpHomeDirFile, "testmessage");
        FTPBlobUploadStrategyTest.assertTrue((String)"File doesn't exists", (boolean)uploaded.exists());
    }

    public void testWriteDenied() throws Exception {
        this.userNamePass = "guest";
        this.setConnection();
        File file = File.createTempFile("amq-data-file-", ".dat");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append("hello world");
        writer.close();
        Session session = this.connection.createSession(false, 1);
        ((ActiveMQConnection)this.connection).setCopyMessageOnSend(false);
        ActiveMQBlobMessage message = (ActiveMQBlobMessage)((ActiveMQSession)session).createBlobMessage(file);
        message.setMessageId(new MessageId("testmessage"));
        try {
            message.onSend();
        }
        catch (JMSException e) {
            e.printStackTrace();
            return;
        }
        FTPBlobUploadStrategyTest.fail((String)"Should have failed with permission denied exception!");
    }
}

