/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.NetworkConnector;

public class BrokerServiceTest
extends TestCase {
    public void testAddRemoveTransportsWithJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setUseJmx(true);
        service.setPersistent(false);
        TransportConnector connector = service.addConnector("tcp://localhost:0");
        service.start();
        service.removeConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveTransportsWithoutJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        TransportConnector connector = service.addConnector("tcp://localhost:0");
        service.start();
        service.removeConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveNetworkWithJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(true);
        NetworkConnector connector = service.addNetworkConnector("multicast://default?group=group-" + System.currentTimeMillis());
        service.start();
        service.removeNetworkConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveNetworkWithoutJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        NetworkConnector connector = service.addNetworkConnector("multicast://default?group=group-" + System.currentTimeMillis());
        service.start();
        service.removeNetworkConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testSystemUsage() {
        BrokerService service = new BrokerService();
        BrokerServiceTest.assertEquals((long)service.getSystemUsage().getMemoryUsage().getLimit(), (long)0x4000000L);
        BrokerServiceTest.assertEquals((long)service.getSystemUsage().getTempUsage().getLimit(), (long)0x1900000000L);
        BrokerServiceTest.assertEquals((long)service.getSystemUsage().getStoreUsage().getLimit(), (long)0x1900000000L);
    }
}

