/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Destination;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.ThreadTracker;

public class TopicSubscriptionTest
extends QueueSubscriptionTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.durable = true;
        this.topic = true;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ThreadTracker.result();
    }

    public void testManyProducersManyConsumers() throws Exception {
        this.consumerCount = 40;
        this.producerCount = 20;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = 1;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.prefetchCount = 1;
        this.messageSize = 1024;
        this.messageCount = 1000;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.messageSize = 1024;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testOneProducerManyConsumersFewMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testOneProducerManyConsumersManyMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    public void testManyProducersOneConsumer() throws Exception {
        this.consumerCount = 1;
        this.producerCount = 20;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    private void assertDestinationMemoryUsageGoesToZero() throws Exception {
        TopicSubscriptionTest.assertEquals((String)"destination memory is back to 0", (int)0, (int)TestSupport.getDestination(this.broker, ActiveMQDestination.transform((Destination)this.destination)).getMemoryUsage().getPercentUsage());
    }
}

