/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterSlaveSlaveDieTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(MasterSlaveSlaveDieTest.class);
    private final AtomicBoolean pluginStopped = new AtomicBoolean(false);

    public void testSlaveDieMasterStays() throws Exception {
        final BrokerService master = new BrokerService();
        master.setBrokerName("master");
        master.setPersistent(false);
        master.addConnector("tcp://localhost:0?wireFormat.maxInactivityDurationInitalDelay=90000");
        master.setWaitForSlave(true);
        master.setPlugins(new BrokerPlugin[]{new Plugin()});
        BrokerService slave = new BrokerService();
        slave.setBrokerName("slave");
        slave.setPersistent(false);
        URI masterUri = ((TransportConnector)master.getTransportConnectors().get(0)).getConnectUri();
        slave.setMasterConnectorURI(masterUri.toString());
        slave.setUseJmx(false);
        slave.getManagementContext().setCreateConnector(false);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                try {
                    master.start();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception starting master: " + e));
                    e.printStackTrace();
                }
            }
        });
        slave.start();
        slave.waitUntilStarted();
        master.waitUntilStarted();
        LOG.info((Object)"killing slave..");
        slave.stop();
        slave.waitUntilStopped();
        LOG.info((Object)"checking master still alive");
        MasterSlaveSlaveDieTest.assertTrue((String)"master is still alive", (boolean)master.isStarted());
        MasterSlaveSlaveDieTest.assertFalse((String)"plugin was not yet stopped", (boolean)this.pluginStopped.get());
        master.stop();
        master.waitUntilStopped();
    }

    class Plugin
    extends BrokerPluginSupport {
        Plugin() {
        }

        public void start() throws Exception {
            LOG.info((Object)"plugin start");
            super.start();
        }

        public void stop() throws Exception {
            LOG.info((Object)"plugin stop");
            MasterSlaveSlaveDieTest.this.pluginStopped.set(true);
            super.stop();
        }
    }
}

