/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class QueueMasterSlaveTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    private static final transient Log LOG = LogFactory.getLog(QueueMasterSlaveTest.class);
    protected BrokerService master;
    protected AtomicReference<BrokerService> slave = new AtomicReference();
    protected CountDownLatch slaveStarted = new CountDownLatch(1);
    protected int inflightMessageCount;
    protected int failureCount = 50;
    protected String uriString = "failover://(tcp://localhost:62001,tcp://localhost:62002)?randomize=false";

    protected void setUp() throws Exception {
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.messageCount = 500;
        this.failureCount = this.messageCount / 2;
        this.topic = this.isTopic();
        this.createMaster();
        this.createSlave();
        Thread.sleep(1000L);
        super.setUp();
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/slave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/master.xml";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.slaveStarted.await(5L, TimeUnit.SECONDS);
        BrokerService brokerService = this.slave.get();
        if (brokerService != null) {
            brokerService.stop();
        }
        this.master.stop();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    protected void messageSent() throws Exception {
        if (++this.inflightMessageCount == this.failureCount) {
            Thread.sleep(1000L);
            LOG.error((Object)"MASTER STOPPED!@!!!!");
            this.master.stop();
        }
    }

    protected boolean isTopic() {
        return false;
    }

    protected void createMaster() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getMasterXml()));
        brokerFactory.afterPropertiesSet();
        this.master = brokerFactory.getBroker();
        this.master.start();
    }

    protected void createSlave() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getSlaveXml()));
        brokerFactory.afterPropertiesSet();
        BrokerService broker = brokerFactory.getBroker();
        broker.start();
        this.slave.set(broker);
        this.slaveStarted.countDown();
    }
}

