/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTopicTransactionTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.test.JmsResourceProvider;

public class TransactedTopicMasterSlaveTest
extends JmsTopicTransactionTest {
    protected BrokerService slave;
    protected int inflightMessageCount;
    protected int failureCount = 50;
    protected String uriString = "failover://(tcp://localhost:62001?soWriteTimeout=15000,tcp://localhost:62002?soWriteTimeout=15000)?randomize=false";
    private boolean stopMaster = false;

    protected void setUp() throws Exception {
        this.failureCount = this.batchCount / 2;
        this.broker = this.createBroker();
        File dir = new File("target" + File.separator + "slave");
        KahaDBPersistenceAdapter adapter = new KahaDBPersistenceAdapter();
        adapter.setDirectory(dir);
        this.broker.start();
        this.slave = new BrokerService();
        this.slave.setBrokerName("slave");
        this.slave.setPersistenceAdapter((PersistenceAdapter)adapter);
        this.slave.setDeleteAllMessagesOnStartup(true);
        this.slave.setMasterConnectorURI("tcp://localhost:62001");
        this.slave.addConnector("tcp://localhost:62002");
        this.slave.start();
        Thread.sleep(1000L);
        this.resourceProvider = this.getJmsResourceProvider();
        this.topic = this.resourceProvider.isTopic();
        this.resourceProvider.setTransacted(true);
        this.connectionFactory = this.resourceProvider.createConnectionFactory();
        this.reconnect();
    }

    protected void tearDown() throws Exception {
        this.slave.stop();
        this.slave = null;
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception, URISyntaxException {
        File dir = new File("target" + File.separator + "master");
        KahaDBPersistenceAdapter adapter = new KahaDBPersistenceAdapter();
        adapter.setDirectory(dir);
        BrokerService broker = new BrokerService();
        broker.setBrokerName("master");
        broker.setPersistenceAdapter((PersistenceAdapter)adapter);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("tcp://localhost:62001");
        return broker;
    }

    protected JmsResourceProvider getJmsResourceProvider() {
        JmsResourceProvider p = super.getJmsResourceProvider();
        p.setServerUri(this.uriString);
        return p;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendReceiveTransactedBatchesWithMasterStop() throws Exception {
        try {
            this.stopMaster = true;
            this.testSendReceiveTransactedBatches();
        }
        finally {
            this.stopMaster = false;
        }
    }

    protected void messageSent() throws Exception {
        if (this.stopMaster && ++this.inflightMessageCount >= this.failureCount) {
            this.inflightMessageCount = 0;
            Thread.sleep(1000L);
            this.broker.stop();
        }
    }
}

