/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.SchedulerBroker;
import org.apache.activemq.util.IOHelper;

public class JmsSchedulerTest
extends EmbeddedBrokerTestSupport {
    public void testCron() throws Exception {
        int COUNT = 10;
        final AtomicInteger count = new AtomicInteger();
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
                count.incrementAndGet();
            }
        });
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        long time = 1000L;
        message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 500L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 9);
        producer.send((Message)message);
        producer.close();
        Thread.sleep(500L);
        SchedulerBroker sb = (SchedulerBroker)this.broker.getBroker().getAdaptor(SchedulerBroker.class);
        JobScheduler js = sb.getJobScheduler();
        List list = js.getAllJobs();
        JmsSchedulerTest.assertEquals((int)1, (int)list.size());
        latch.await(240L, TimeUnit.SECONDS);
        JmsSchedulerTest.assertEquals((int)10, (int)count.get());
    }

    public void testSchedule() throws Exception {
        boolean COUNT = true;
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(1);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        connection.start();
        long time = 5000L;
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        producer.send((Message)message);
        producer.close();
        Thread.sleep(2000L);
        JmsSchedulerTest.assertEquals((long)latch.getCount(), (long)1L);
        latch.await(5L, TimeUnit.SECONDS);
        JmsSchedulerTest.assertEquals((long)latch.getCount(), (long)0L);
    }

    public void testTransactedSchedule() throws Exception {
        boolean COUNT = true;
        Connection connection = this.createConnection();
        final Session session = connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(1);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    session.commit();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                latch.countDown();
            }
        });
        connection.start();
        long time = 5000L;
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        producer.send((Message)message);
        session.commit();
        producer.close();
        Thread.sleep(2000L);
        JmsSchedulerTest.assertEquals((long)latch.getCount(), (long)1L);
        latch.await(5L, TimeUnit.SECONDS);
        JmsSchedulerTest.assertEquals((long)latch.getCount(), (long)0L);
    }

    public void testScheduleRepeated() throws Exception {
        int NUMBER = 10;
        final AtomicInteger count = new AtomicInteger();
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
                count.incrementAndGet();
            }
        });
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        long time = 1000L;
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 500L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 9);
        producer.send((Message)message);
        producer.close();
        JmsSchedulerTest.assertEquals((long)latch.getCount(), (long)10L);
        latch.await(10L, TimeUnit.SECONDS);
        JmsSchedulerTest.assertEquals((long)0L, (long)latch.getCount());
        Thread.sleep(1000L);
        JmsSchedulerTest.assertEquals((int)10, (int)count.get());
    }

    public void testScheduleRestart() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        long time = 5000L;
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        producer.send((Message)message);
        producer.close();
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false);
        this.broker.start();
        this.broker.waitUntilStarted();
        connection = this.createConnection();
        connection.start();
        session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message msg = consumer.receive(5000L);
        JmsSchedulerTest.assertNotNull((String)"Didn't receive the message", (Object)msg);
        producer = session.createProducer((Destination)this.destination);
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        producer.send((Message)message);
        producer.close();
    }

    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker(true);
    }

    protected BrokerService createBroker(boolean delete) throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        if (delete) {
            IOHelper.mkdirs((File)schedulerDirectory);
            IOHelper.deleteChildren((File)schedulerDirectory);
        }
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setDataDirectory("target");
        answer.setSchedulerDirectoryFile(schedulerDirectory);
        answer.setSchedulerSupport(true);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

