/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.util.IOHelper;
import org.apache.kahadb.util.ByteSequence;

public class JobSchedulerStoreTest
extends TestCase {
    public void testRestart() throws Exception {
        JobSchedulerStore store = new JobSchedulerStore();
        File directory = new File("target/test/ScheduledDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        store.setDirectory(directory);
        int NUMBER = 1000;
        store.start();
        ArrayList<ByteSequence> list = new ArrayList<ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            ByteSequence buff = new ByteSequence(new String("testjob" + i).getBytes());
            list.add(buff);
        }
        JobScheduler js = store.getJobScheduler("test");
        int count = 0;
        long startTime = 10000L;
        for (ByteSequence job : list) {
            js.schedule("id:" + count++, job, "", startTime, 10000L, -1);
        }
        List test = js.getAllJobs();
        JobSchedulerStoreTest.assertEquals((int)list.size(), (int)test.size());
        store.stop();
        store.start();
        js = store.getJobScheduler("test");
        test = js.getAllJobs();
        JobSchedulerStoreTest.assertEquals((int)list.size(), (int)test.size());
        for (int i = 0; i < list.size(); ++i) {
            String orig = new String(((ByteSequence)list.get(i)).getData());
            String payload = new String(((Job)test.get(i)).getPayload());
            JobSchedulerStoreTest.assertEquals((String)orig, (String)payload);
        }
    }
}

