/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.ResponseCorrelator;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.junit.Test;

public class AMQ2364Test {
    @Test
    public void testRollbackLeak() throws Exception {
        int messageCount = 1000;
        URI failoverUri = new URI("failover:(vm://localhost)?jms.redeliveryPolicy.maximumRedeliveries=0");
        ActiveMQQueue dest = new ActiveMQQueue("Failover.Leak");
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(failoverUri);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        for (int i = 0; i < messageCount; ++i) {
            producer.send((Message)session.createTextMessage("Test message #" + i));
        }
        producer.close();
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        final CountDownLatch latch = new CountDownLatch(messageCount);
        consumer.setMessageListener(new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(Message msg) {
                try {
                    session.rollback();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            }
        });
        latch.await();
        consumer.close();
        session.close();
        ResponseCorrelator respCorr = (ResponseCorrelator)connection.getTransport();
        MutexTransport mutexTrans = (MutexTransport)respCorr.getNext();
        FailoverTransport failoverTrans = (FailoverTransport)mutexTrans.getNext();
        Field stateTrackerField = FailoverTransport.class.getDeclaredField("stateTracker");
        stateTrackerField.setAccessible(true);
        ConnectionStateTracker stateTracker = (ConnectionStateTracker)stateTrackerField.get(failoverTrans);
        Field statesField = ConnectionStateTracker.class.getDeclaredField("connectionStates");
        statesField.setAccessible(true);
        ConcurrentHashMap states = (ConcurrentHashMap)statesField.get(stateTracker);
        ConnectionState state = (ConnectionState)states.get(connection.getConnectionInfo().getConnectionId());
        Collection transactionStates = state.getTransactionStates();
        connection.stop();
        connection.close();
        Assert.assertEquals((String)"Transaction states not cleaned up", (int)0, (int)transactionStates.size());
    }
}

