/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;

public class AMQ2413Test
extends CombinationTestSupport
implements MessageListener {
    BrokerService broker;
    private ActiveMQConnectionFactory factory;
    private static final int HANG_THRESHOLD = 60;
    private static final int SEND_COUNT = 10000;
    private static final int RECEIVER_THINK_TIME = 1;
    private static final int CONSUMER_COUNT = 1;
    private static final int PRODUCER_COUNT = 50;
    public int deliveryMode = 1;
    public int ackMode = 3;
    public boolean useVMCursor = false;
    public boolean useOptimizeAcks = false;
    private ArrayList<Service> services = new ArrayList(51);
    AtomicInteger count = new AtomicInteger(0);
    Semaphore receivedMessages;
    AtomicBoolean running = new AtomicBoolean(false);

    public void initCombos() {
        this.addCombinationValues("deliveryMode", new Object[]{2, 1});
        this.addCombinationValues("ackMode", new Object[]{3, 1});
        this.addCombinationValues("useVMCursor", new Object[]{true, false});
    }

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "test-data" + File.separator + "AMQ2401Test");
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector("tcp://0.0.0.0:2401");
        PolicyMap policies = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setMemoryLimit(0x100000L);
        entry.setProducerFlowControl(true);
        if (this.useVMCursor) {
            entry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        }
        entry.setQueue(">");
        policies.setDefaultEntry(entry);
        this.broker.setDestinationPolicy(policies);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.count.set(0);
        this.receivedMessages = new Semaphore(0);
        this.factory = new ActiveMQConnectionFactory("tcp://0.0.0.0:2401");
        this.setAutoFail(true);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.running.set(false);
        for (Service service : this.services) {
            service.close();
        }
        this.broker.stop();
        this.broker.waitUntilStopped();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceipt() throws Exception {
        this.running.set(true);
        TestProducer p = null;
        TestConsumer c = null;
        try {
            int i;
            for (i = 0; i < 1; ++i) {
                TestConsumer consumer = new TestConsumer();
                consumer.start();
                this.services.add(consumer);
            }
            for (i = 0; i < 50; ++i) {
                TestProducer producer = new TestProducer(i);
                producer.start();
                this.services.add(producer);
            }
            this.waitForMessageReceipt();
        }
        finally {
            if (p != null) {
                p.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public void onMessage(Message message) {
        this.receivedMessages.release();
        if (this.count.incrementAndGet() % 100 == 0) {
            System.out.println("Received message " + this.count);
        }
        try {
            Thread.currentThread();
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMessageReceipt() throws InterruptedException, TimeoutException {
        try {
            while (this.count.get() < 10000) {
                if (this.receivedMessages.tryAcquire(60L, TimeUnit.SECONDS)) continue;
                if (this.count.get() == 10000) {
                    break;
                }
                throw new TimeoutException("@count=" + this.count.get() + " Message not received for more than " + 60 + " seconds");
            }
        }
        finally {
            this.running.set(false);
        }
    }

    public static Test suite() {
        return AMQ2413Test.suite(AMQ2413Test.class);
    }

    private class TestConsumer
    implements Runnable,
    Service {
        ActiveMQConnection connection;
        Session session;
        MessageConsumer consumer;
        Thread thread;

        TestConsumer() throws Exception {
            AMQ2413Test.this.factory.setOptimizeAcknowledge(false);
            this.connection = (ActiveMQConnection)AMQ2413Test.this.factory.createConnection();
            if (AMQ2413Test.this.useOptimizeAcks) {
                this.connection.setOptimizeAcknowledge(true);
            }
            this.session = this.connection.createSession(false, AMQ2413Test.this.ackMode);
            this.consumer = this.session.createConsumer((Destination)this.session.createQueue("AMQ2401Test"));
            this.consumer.setMessageListener((MessageListener)AMQ2413Test.this);
        }

        public void start() throws Exception {
            this.connection.start();
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }

        public void run() {
            while (AMQ2413Test.this.running.get()) {
                try {
                    AMQ2413Test.this.onMessage(this.consumer.receive());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class TestProducer
    implements Runnable,
    Service {
        Thread thread;
        BytesMessage message;
        int id;
        Connection connection;
        Session session;
        MessageProducer producer;

        TestProducer(int id) throws Exception {
            this.id = id;
            this.thread = new Thread((Runnable)this, "TestProducer-" + id);
            this.connection = AMQ2413Test.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 3);
            this.producer = this.session.createProducer((Destination)this.session.createQueue("AMQ2401Test"));
        }

        public void start() {
            this.thread.start();
        }

        public void run() {
            int count = 200;
            for (int i = 1; i <= count; ++i) {
                try {
                    if (i % 100 == 0) {
                        TestProducer testProducer = this;
                        System.out.println(testProducer.thread.currentThread().getName() + " Sending message " + i);
                    }
                    this.message = this.session.createBytesMessage();
                    this.message.writeBytes(new byte[1024]);
                    this.producer.setDeliveryMode(AMQ2413Test.this.deliveryMode);
                    this.producer.send((Message)this.message);
                    continue;
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                    break;
                }
            }
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    private static interface Service {
        public void start() throws Exception;

        public void close();
    }
}

