/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class AMQ2571Test
extends EmbeddedBrokerTestSupport {
    public void testTempQueueClosing() {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.bindAddress);
            Connection connectionA = connectionFactory.createConnection();
            connectionA.start();
            Session sessionA = connectionA.createSession(false, 1);
            TemporaryQueue tempQueue = sessionA.createTemporaryQueue();
            Connection connectionB = connectionFactory.createConnection();
            connectionB.start();
            Session sessionB = connectionB.createSession(false, 1);
            final MessageProducer producerB = sessionB.createProducer((Destination)tempQueue);
            producerB.setDeliveryMode(1);
            final TextMessage message = sessionB.createTextMessage("Testing AMQ TempQueue.");
            Thread sendingThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < 100000; ++i) {
                            producerB.send((Message)message);
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            });
            sendingThread.start();
            connectionA.close();
            sendingThread.join();
            try {
                producerB.send((Message)message);
                AMQ2571Test.fail((String)"Involuntary recreated temporary queue.");
            }
            catch (JMSException e) {
                AMQ2571Test.assertTrue((String)"TempQueue does not exist anymore.", (boolean)true);
            }
        }
        catch (Exception e) {
            AMQ2571Test.fail((String)("Unexpected exception " + e));
        }
    }

    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

