/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.bugs.MessageSender;
import org.apache.activemq.bugs.Receiver;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataFileNotDeletedTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(DataFileNotDeletedTest.class);
    private final CountDownLatch latch = new CountDownLatch(max_messages);
    private static int max_messages = 600;
    private static int messageCounter;
    private final String destinationName = this.getName() + "_Queue";
    private BrokerService broker;
    private Connection receiverConnection;
    private Connection producerConnection;
    final boolean useTopic = false;
    AMQPersistenceAdapter persistentAdapter;
    protected static final String payload;

    public void setUp() throws Exception {
        messageCounter = 0;
        this.startBroker();
        this.receiverConnection = this.createConnection();
        this.receiverConnection.start();
        this.producerConnection = this.createConnection();
        this.producerConnection.start();
    }

    public void tearDown() throws Exception {
        this.receiverConnection.close();
        this.producerConnection.close();
        this.broker.stop();
    }

    public void testForDataFileNotDeleted() throws Exception {
        this.doTestForDataFileNotDeleted(false);
    }

    public void testForDataFileNotDeletedTransacted() throws Exception {
        this.doTestForDataFileNotDeleted(true);
    }

    private void doTestForDataFileNotDeleted(boolean transacted) throws Exception {
        Receiver receiver = new Receiver(){

            public void receive(String s) throws Exception {
                messageCounter++;
                DataFileNotDeletedTest.this.latch.countDown();
            }
        };
        this.buildReceiver(this.receiverConnection, this.destinationName, transacted, receiver, false);
        MessageSender producer = new MessageSender(this.destinationName, this.producerConnection, transacted, false);
        for (int i = 0; i < max_messages; ++i) {
            producer.send(payload);
        }
        this.latch.await();
        DataFileNotDeletedTest.assertEquals((int)max_messages, (int)messageCounter);
        LOG.info((Object)("Sent and received + " + messageCounter + ", file count " + this.persistentAdapter.getAsyncDataManager().getFiles().size()));
        this.waitFordataFilesToBeCleanedUp(this.persistentAdapter.getAsyncDataManager(), 60000, 2);
    }

    private void waitFordataFilesToBeCleanedUp(AsyncDataManager asyncDataManager, int timeout, int numExpected) throws InterruptedException {
        long expiry = System.currentTimeMillis() + (long)timeout;
        while (expiry > System.currentTimeMillis() && asyncDataManager.getFiles().size() > numExpected) {
            Thread.sleep(1000L);
        }
        DataFileNotDeletedTest.assertEquals((String)"persistence adapter dataManager has correct number of files", (int)numExpected, (int)asyncDataManager.getFiles().size());
    }

    private Connection createConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        return factory.createConnection();
    }

    private void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.addConnector("tcp://localhost:61616").setName("Default");
        this.broker.setPersistenceFactory((PersistenceAdapterFactory)new AMQPersistenceAdapterFactory());
        AMQPersistenceAdapterFactory factory = (AMQPersistenceAdapterFactory)this.broker.getPersistenceFactory();
        factory.setMaxFileLength(20480);
        factory.setCheckpointInterval(500L);
        factory.setCleanupInterval(500L);
        factory.setSyncOnWrite(false);
        this.persistentAdapter = (AMQPersistenceAdapter)this.broker.getPersistenceAdapter();
        this.broker.start();
        LOG.info((Object)"Starting broker..");
    }

    private void buildReceiver(Connection connection, String queueName, boolean transacted, final Receiver receiver, boolean isTopic) throws Exception {
        final Session session = transacted ? connection.createSession(true, 0) : connection.createSession(false, 1);
        MessageConsumer inputMessageConsumer = session.createConsumer((Destination)(isTopic ? session.createTopic(queueName) : session.createQueue(queueName)));
        MessageListener messageListener = new MessageListener(){

            public void onMessage(Message message) {
                try {
                    ObjectMessage objectMessage = (ObjectMessage)message;
                    String s = (String)((Object)objectMessage.getObject());
                    receiver.receive(s);
                    if (session.getTransacted()) {
                        session.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        inputMessageConsumer.setMessageListener(messageListener);
    }

    static {
        payload = new String(new byte[512]);
    }
}

