/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.store.kahadb.plist.PListStore;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.TempUsage;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TempStorageBlockedBrokerTest {
    public boolean consumeAll = false;
    public int deliveryMode = 2;
    private static final Log LOG = LogFactory.getLog(TempStorageBlockedBrokerTest.class);
    private static final int MESSAGES_COUNT = 1000;
    private static byte[] buf = new byte[4096];
    private BrokerService broker;
    AtomicInteger messagesSent = new AtomicInteger(0);
    AtomicInteger messagesConsumed = new AtomicInteger(0);
    protected long messageReceiveTimeout = 10L;
    Destination destination = new ActiveMQTopic("FooTwo");

    @Test
    public void runProducerWithHungConsumer() throws Exception {
        long origTempUsage = this.broker.getSystemUsage().getTempUsage().getUsage();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61618");
        ActiveMQPrefetchPolicy prefetch = new ActiveMQPrefetchPolicy();
        prefetch.setTopicPrefetch(10);
        factory.setPrefetchPolicy(prefetch);
        Connection consumerConnection = factory.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer(this.destination);
        final Connection producerConnection = factory.createConnection();
        producerConnection.start();
        final CountDownLatch producerHasSentTenMessages = new CountDownLatch(10);
        Thread producingThread = new Thread("Producing thread"){

            public void run() {
                try {
                    Session session = producerConnection.createSession(false, 1);
                    MessageProducer producer = session.createProducer(TempStorageBlockedBrokerTest.this.destination);
                    producer.setDeliveryMode(TempStorageBlockedBrokerTest.this.deliveryMode);
                    for (int idx = 0; idx < 1000; ++idx) {
                        TextMessage message = session.createTextMessage(new String(buf) + idx);
                        producer.send((Message)message);
                        TempStorageBlockedBrokerTest.this.messagesSent.incrementAndGet();
                        producerHasSentTenMessages.countDown();
                        Thread.sleep(10L);
                        if (idx == 0 || idx % 100 != 0) continue;
                        LOG.info((Object)("Sent Message " + idx));
                        LOG.info((Object)("Temp Store Usage " + TempStorageBlockedBrokerTest.this.broker.getSystemUsage().getTempUsage().getUsage()));
                    }
                    producer.close();
                    session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        Assert.assertTrue((String)"producer has sent 10 in a reasonable time", (boolean)producerHasSentTenMessages.await(30L, TimeUnit.SECONDS));
        int count = 0;
        Message m = null;
        while ((m = consumer.receive(this.messageReceiveTimeout)) != null) {
            if (++count != 0 && count % 10 == 0) {
                LOG.info((Object)("Recieved Message (" + count + "):" + m));
            }
            this.messagesConsumed.incrementAndGet();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LOG.info((Object)"error sleeping");
            }
        }
        LOG.info((Object)("Connection Timeout: Retrying.. count: " + count));
        while ((m = consumer.receive(this.messageReceiveTimeout)) != null) {
            if (++count != 0 && count % 10 == 0) {
                LOG.info((Object)("Recieved Message (" + count + "):" + m));
            }
            this.messagesConsumed.incrementAndGet();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LOG.info((Object)"error sleeping");
            }
        }
        LOG.info((Object)("consumer session closing: consumed count: " + count));
        consumerSession.close();
        producingThread.join();
        long tempUsageBySubscription = this.broker.getSystemUsage().getTempUsage().getUsage();
        LOG.info((Object)("Orig Usage: " + origTempUsage + ", currentUsage: " + tempUsageBySubscription));
        producerConnection.close();
        consumerConnection.close();
        LOG.info((Object)("Subscrition Usage: " + tempUsageBySubscription + ", endUsage: " + this.broker.getSystemUsage().getTempUsage().getUsage()));
        Assert.assertEquals((String)("Incorrect number of Messages Sent: " + this.messagesSent.get()), (long)this.messagesSent.get(), (long)1000L);
        Assert.assertEquals((String)("Incorrect number of Messages Consumed: " + this.messagesConsumed.get()), (long)this.messagesConsumed.get(), (long)1000L);
    }

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        AMQPersistenceAdapter persistence = new AMQPersistenceAdapter();
        persistence.setSyncOnWrite(false);
        File directory = new File("target" + File.separator + "activemq-data");
        persistence.setDirectory(directory);
        File tmpDir = new File(directory, "tmp");
        IOHelper.deleteChildren((File)tmpDir);
        PListStore tempStore = new PListStore();
        tempStore.setDirectory(tmpDir);
        tempStore.start();
        SystemUsage sysUsage = new SystemUsage("mySysUsage", (PersistenceAdapter)persistence, tempStore);
        MemoryUsage memUsage = new MemoryUsage();
        memUsage.setLimit(0x100000L);
        StoreUsage storeUsage = new StoreUsage();
        storeUsage.setLimit(0x2600000L);
        TempUsage tmpUsage = new TempUsage();
        tmpUsage.setLimit(0x2600000L);
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setProducerFlowControl(false);
        defaultPolicy.setMemoryLimit(10240L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        sysUsage.setMemoryUsage(memUsage);
        sysUsage.setStoreUsage(storeUsage);
        sysUsage.setTempUsage(tmpUsage);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.setSystemUsage(sysUsage);
        this.broker.setTempDataStore(tempStore);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistence);
        this.broker.addConnector("tcp://localhost:61618").setName("Default");
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }
}

