/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs.amq1974;

import java.io.File;
import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.simple.SimpleDiscoveryAgent;

public class TryJmsClient {
    private final BrokerService broker = new BrokerService();

    public static void main(String[] args) throws Exception {
        new TryJmsClient().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws Exception {
        this.broker.setUseJmx(false);
        this.broker.setPersistent(true);
        this.broker.setBrokerName("TestBroker");
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0xA00000L);
        KahaPersistenceAdapter persist = new KahaPersistenceAdapter();
        persist.setDirectory(new File("/tmp/broker2"));
        persist.setMaxDataFileLength(0x1400000L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persist);
        String brokerUrl = "tcp://localhost:4501";
        this.broker.addConnector(brokerUrl);
        this.broker.start();
        this.addNetworkBroker();
        this.startUsageMonitor(this.broker);
        this.startMessageSend();
        TryJmsClient tryJmsClient = this;
        synchronized (tryJmsClient) {
            this.wait();
        }
    }

    private void startUsageMonitor(final BrokerService brokerService) {
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println("ActiveMQ memeory " + brokerService.getSystemUsage().getMemoryUsage().getPercentUsage() + " " + brokerService.getSystemUsage().getMemoryUsage().getUsage());
                    System.out.println("ActiveMQ message store " + brokerService.getSystemUsage().getStoreUsage().getPercentUsage());
                    System.out.println("ActiveMQ temp space " + brokerService.getSystemUsage().getTempUsage().getPercentUsage());
                }
            }
        }).start();
    }

    private void addNetworkBroker() throws Exception {
        DiscoveryNetworkConnector dnc = new DiscoveryNetworkConnector();
        dnc.setNetworkTTL(1);
        dnc.setBrokerName("TestBroker");
        dnc.setName("Broker1Connector");
        dnc.setDynamicOnly(true);
        SimpleDiscoveryAgent discoveryAgent = new SimpleDiscoveryAgent();
        String remoteUrl = "tcp://localhost:4500";
        discoveryAgent.setServices(remoteUrl);
        dnc.setDiscoveryAgent((DiscoveryAgent)discoveryAgent);
        this.broker.addNetworkConnector((NetworkConnector)dnc);
        dnc.start();
    }

    private void startMessageSend() {
        new Thread(new MessageSend()).start();
    }

    private class MessageSend
    implements Runnable {
        private MessageSend() {
        }

        public void run() {
            try {
                String url = "vm://TestBroker";
                ActiveMQConnection connection = ActiveMQConnection.makeConnection((String)url);
                connection.setDispatchAsync(true);
                Session session = connection.createSession(false, 1);
                Topic dest = session.createTopic("TestDestination");
                MessageProducer producer = session.createProducer((Destination)dest);
                producer.setDeliveryMode(2);
                for (int i = 0; i < 99999999; ++i) {
                    TextMessage message = session.createTextMessage("test" + i);
                    try {
                        producer.send((Message)message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("TOTAL number of messages sent " + i);
                        break;
                    }
                    if (i % 1000 != 0) continue;
                    System.out.println("sent message " + message.getJMSMessageID());
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

