/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs.embedded;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.bugs.embedded.ThreadExplorer;
import org.apache.log4j.Logger;

public class EmbeddedActiveMQ {
    private static Logger logger = Logger.getLogger(EmbeddedActiveMQ.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        BrokerService brokerService = null;
        Connection connection = null;
        logger.info((Object)"Start...");
        try {
            brokerService = new BrokerService();
            brokerService.setBrokerName("TestMQ");
            brokerService.setUseJmx(true);
            logger.info((Object)("Broker '" + brokerService.getBrokerName() + "' is starting........"));
            brokerService.start();
            ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://TestMQ");
            connection = fac.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("TEST.QUEUE");
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 1000; ++i) {
                TextMessage msg = session.createTextMessage("test" + i);
                producer.send((Message)msg);
            }
            logger.info((Object)ThreadExplorer.show("Active threads after start:"));
            System.out.println("Press return to stop........");
            String key = br.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                logger.info((Object)("Broker '" + brokerService.getBrokerName() + "' is stopping........"));
                connection.close();
                brokerService.stop();
                EmbeddedActiveMQ.sleep(8);
                logger.info((Object)ThreadExplorer.show("Active threads after stop:"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)"Waiting for list theads is greater then 1 ...");
        int numTh = ThreadExplorer.active();
        while (numTh > 2) {
            EmbeddedActiveMQ.sleep(3);
            numTh = ThreadExplorer.active();
            logger.info((Object)ThreadExplorer.show("Still active threads:"));
        }
        System.out.println("Stop...");
    }

    private static void sleep(int second) {
        try {
            logger.info((Object)("Waiting for " + second + "s..."));
            Thread.sleep((long)second * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

