/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.SimpleNetworkTest;

public class DuplexNetworkTest
extends SimpleNetworkTest {
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/duplexLocalBroker.xml";
    }

    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("remoteBroker");
        broker.addConnector("tcp://localhost:61617");
        return broker;
    }

    public void testTempQueues() throws Exception {
        TemporaryQueue temp = this.localSession.createTemporaryQueue();
        MessageProducer producer = this.localSession.createProducer((Destination)temp);
        producer.send((Message)this.localSession.createTextMessage("test"));
        Thread.sleep(100L);
        DuplexNetworkTest.assertEquals((String)"Destination not created", (int)1, (int)this.remoteBroker.getAdminView().getTemporaryQueues().length);
        temp.delete();
        Thread.sleep(100L);
        DuplexNetworkTest.assertEquals((String)"Destination not deleted", (int)0, (int)this.remoteBroker.getAdminView().getTemporaryQueues().length);
    }
}

