/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import java.io.File;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.SimpleQueueTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class KahaDBQueueTest
extends SimpleQueueTest {
    protected void setUp() throws Exception {
        this.numberOfDestinations = 25;
        this.numberofProducers = 1;
        super.setUp();
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        File dataFileDir = new File("target/test-amq-data/perfTest/kahadb");
        File archiveDir = new File(dataFileDir, "archive");
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setDirectory(dataFileDir);
        kaha.setDirectoryArchive(archiveDir);
        kaha.setArchiveDataLogs(false);
        kaha.setEnableJournalDiskSyncs(true);
        kaha.setEnableIndexWriteAsync(true);
        kaha.setIndexCacheSize(10000);
        answer.setPersistenceAdapter((PersistenceAdapter)kaha);
        answer.addConnector(uri);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

