/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.SimpleQueueTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueConnectionMemoryTest
extends SimpleQueueTest {
    private static final transient Log LOG = LogFactory.getLog(QueueConnectionMemoryTest.class);

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createTemporaryQueue();
    }

    public void testPerformance() throws JMSException {
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        KahaPersistenceAdapter adaptor = new KahaPersistenceAdapter();
        answer.setPersistenceAdapter((PersistenceAdapter)adaptor);
        answer.addConnector(uri);
        answer.setDeleteAllMessagesOnStartup(true);
    }

    public void testMemory() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker(this.bindAddress);
        }
        this.factory = this.createConnectionFactory(this.bindAddress);
        Connection con = this.factory.createConnection();
        Session session = con.createSession(false, 1);
        Destination destination = this.createDestination(session, this.destinationName);
        con.close();
        for (int i = 0; i < 3; ++i) {
            Connection connection = this.factory.createConnection();
            connection.start();
            Session s = connection.createSession(false, 1);
            TemporaryQueue dest = s.createTemporaryQueue();
            MessageConsumer consumer = s.createConsumer((Destination)dest);
            LOG.debug((Object)("Created connnection: " + i));
            Thread.sleep(1000L);
        }
        Thread.sleep(Integer.MAX_VALUE);
    }
}

