/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.amq.AMQPersistenceAdapterFactory;

public class SimpleDurableTopicTest
extends SimpleTopicTest {
    protected long initialConsumerDelay = 0L;

    protected void setUp() throws Exception {
        this.numberOfDestinations = 1;
        this.numberOfConsumers = 1;
        this.numberofProducers = Integer.parseInt(System.getProperty("SimpleDurableTopicTest.numberofProducers", "20"), 20);
        this.sampleCount = Integer.parseInt(System.getProperty("SimpleDurableTopicTest.sampleCount", "1000"), 10);
        this.playloadSize = 1024;
        super.setUp();
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        AMQPersistenceAdapterFactory persistenceFactory = new AMQPersistenceAdapterFactory();
        persistenceFactory.setMaxFileLength(16384);
        persistenceFactory.setPersistentIndex(true);
        persistenceFactory.setCleanupInterval(10000L);
        answer.setPersistenceFactory((PersistenceAdapterFactory)persistenceFactory);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer pp = new PerfProducer(fac, dest, payload);
        pp.setDeliveryMode(2);
        return pp;
    }

    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        PerfConsumer result = new PerfConsumer(fac, dest, "subs:" + number);
        result.setInitialDelay(this.initialConsumerDelay);
        return result;
    }

    protected ActiveMQConnectionFactory createConnectionFactory(String uri) throws Exception {
        ActiveMQConnectionFactory result = super.createConnectionFactory(uri);
        return result;
    }
}

