/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleNetworkTest
extends SimpleTopicTest {
    private static final Log LOG = LogFactory.getLog(SimpleNetworkTest.class);
    protected String consumerBindAddress = "tcp://localhost:61616";
    protected String producerBindAddress = "tcp://localhost:61617";
    protected static final String CONSUMER_BROKER_NAME = "Consumer";
    protected static final String PRODUCER_BROKER_NAME = "Producer";
    protected BrokerService consumerBroker;
    protected BrokerService producerBroker;
    protected ActiveMQConnectionFactory consumerFactory;
    protected ActiveMQConnectionFactory producerFactory;

    protected void setUp() throws Exception {
        if (this.consumerBroker == null) {
            this.consumerBroker = this.createConsumerBroker(this.consumerBindAddress);
        }
        if (this.producerBroker == null) {
            this.producerBroker = this.createProducerBroker(this.producerBindAddress);
        }
        this.consumerFactory = this.createConnectionFactory(this.consumerBindAddress);
        this.consumerFactory.setDispatchAsync(true);
        ActiveMQPrefetchPolicy policy = new ActiveMQPrefetchPolicy();
        policy.setQueuePrefetch(100);
        this.consumerFactory.setPrefetchPolicy(policy);
        this.producerFactory = this.createConnectionFactory(this.producerBindAddress);
        Connection con = this.consumerFactory.createConnection();
        Session session = con.createSession(false, 1);
        this.producers = new PerfProducer[this.numberofProducers * this.numberOfDestinations];
        this.consumers = new PerfConsumer[this.numberOfConsumers * this.numberOfDestinations];
        for (int k = 0; k < this.numberOfDestinations; ++k) {
            int i;
            Destination destination = this.createDestination(session, this.destinationName + ":" + k);
            LOG.info((Object)("Testing against destination: " + destination));
            for (i = 0; i < this.numberOfConsumers; ++i) {
                this.consumers[i] = this.createConsumer((ConnectionFactory)this.consumerFactory, destination, i);
                this.consumers[i].start();
            }
            for (i = 0; i < this.numberofProducers; ++i) {
                this.array = new byte[this.playloadSize];
                for (int j = i; j < this.array.length; ++j) {
                    this.array[j] = (byte)j;
                }
                this.producers[i] = this.createProducer((ConnectionFactory)this.producerFactory, destination, i, this.array);
                this.producers[i].start();
            }
        }
        con.close();
    }

    protected void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.numberOfConsumers; ++i) {
            this.consumers[i].shutDown();
        }
        for (i = 0; i < this.numberofProducers; ++i) {
            this.producers[i].shutDown();
        }
        if (this.producerBroker != null) {
            this.producerBroker.stop();
            this.producerBroker = null;
        }
        if (this.consumerBroker != null) {
            this.consumerBroker.stop();
            this.consumerBroker = null;
        }
    }

    protected BrokerService createConsumerBroker(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        this.configureConsumerBroker(answer, uri);
        answer.start();
        return answer;
    }

    protected void configureConsumerBroker(BrokerService answer, String uri) throws Exception {
        this.configureBroker(answer);
        answer.setPersistent(false);
        answer.setBrokerName(CONSUMER_BROKER_NAME);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    protected BrokerService createProducerBroker(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        this.configureProducerBroker(answer, uri);
        answer.start();
        return answer;
    }

    protected void configureProducerBroker(BrokerService answer, String uri) throws Exception {
        this.configureBroker(answer);
        answer.setBrokerName(PRODUCER_BROKER_NAME);
        answer.setMonitorConnectionSplits(false);
        answer.setPersistent(false);
        answer.setDeleteAllMessagesOnStartup(true);
        NetworkConnector connector = answer.addNetworkConnector("static://" + this.consumerBindAddress);
        connector.setDuplex(true);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    protected void configureBroker(BrokerService service) throws Exception {
    }
}

