/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerBean
extends Assert
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(ConsumerBean.class);
    private final List<Message> messages = new ArrayList<Message>();
    private boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> flushMessages() {
        ArrayList<Message> answer = null;
        List<Message> list = this.messages;
        synchronized (list) {
            answer = new ArrayList<Message>(this.messages);
            this.messages.clear();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        List<Message> list = this.messages;
        synchronized (list) {
            this.messages.add(message);
            if (this.verbose) {
                LOG.info((Object)("Received: " + message));
            }
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageToArrive() {
        long start;
        block5: {
            LOG.info((Object)"Waiting for message to arrive");
            start = System.currentTimeMillis();
            try {
                if (!this.hasReceivedMessage()) break block5;
                List<Message> list = this.messages;
                synchronized (list) {
                    this.messages.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Caught: " + e));
            }
        }
        long end = System.currentTimeMillis() - start;
        LOG.info((Object)("End of wait for " + end + " millis"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        long maxRemainingMessageCount = Math.max(0, messageCount - this.messages.size());
        LOG.info((Object)("Waiting for (" + maxRemainingMessageCount + ") message(s) to arrive"));
        long start = System.currentTimeMillis();
        long maxWaitTime = start + 120000L;
        while (maxRemainingMessageCount > 0L) {
            try {
                List<Message> list = this.messages;
                synchronized (list) {
                    this.messages.wait(1000L);
                }
                if (this.hasReceivedMessages(messageCount) || System.currentTimeMillis() > maxWaitTime) {
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Caught: " + e));
            }
            maxRemainingMessageCount = Math.max(0, messageCount - this.messages.size());
        }
        long end = System.currentTimeMillis() - start;
        LOG.info((Object)("End of wait for " + end + " millis"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertMessagesArrived(int total) {
        this.waitForMessagesToArrive(total);
        List<Message> list = this.messages;
        synchronized (list) {
            int count = this.messages.size();
            ConsumerBean.assertEquals((String)"Messages received", (int)total, (int)count);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean hasReceivedMessage() {
        return this.messages.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasReceivedMessages(int messageCount) {
        List<Message> list = this.messages;
        synchronized (list) {
            return this.messages.size() >= messageCount;
        }
    }
}

