/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;

public abstract class PersistenceAdapterTestSupport
extends TestCase {
    protected PersistenceAdapter pa;
    protected BrokerService brokerService = new BrokerService();

    protected abstract PersistenceAdapter createPersistenceAdapter(boolean var1) throws Exception;

    protected void setUp() throws Exception {
        this.pa = this.createPersistenceAdapter(true);
        this.pa.start();
    }

    protected void tearDown() throws Exception {
        if (this.pa != null) {
            this.pa.stop();
            this.pa = null;
        }
    }

    public void testStoreCanHandleDupMessages() throws Exception {
        MessageStore ms = this.pa.createQueueMessageStore(new ActiveMQQueue("TEST"));
        ConnectionContext context = new ConnectionContext();
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("test");
        MessageId messageId = new MessageId("ID:localhost-56913-1254499826208-0:0:1:1:1");
        messageId.setBrokerSequenceId(1L);
        message.setMessageId(messageId);
        ms.addMessage(context, (Message)message);
        message = new ActiveMQTextMessage();
        message.setText("test");
        messageId = new MessageId("ID:localhost-56913-1254499826208-0:0:1:1:1");
        messageId.setBrokerSequenceId(2L);
        message.setMessageId(messageId);
        ms.addMessage(context, (Message)message);
        final AtomicInteger recovered = new AtomicInteger();
        ms.recover(new MessageRecoveryListener(){

            public boolean hasSpace() {
                return true;
            }

            public boolean isDuplicate(MessageId ref) {
                return false;
            }

            public boolean recoverMessage(Message message) throws Exception {
                recovered.incrementAndGet();
                return true;
            }

            public boolean recoverMessageReference(MessageId ref) throws Exception {
                recovered.incrementAndGet();
                return true;
            }
        });
        PersistenceAdapterTestSupport.assertEquals((int)1, (int)recovered.get());
    }
}

