/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayInputStream;
import org.apache.kahadb.util.DataByteArrayOutputStream;

public class PBMesssagesTest
extends TestCase {
    public void testKahaAddMessageCommand() throws IOException {
        KahaAddMessageCommand expected = new KahaAddMessageCommand();
        expected.setDestination((KahaDestination)((KahaDestination)new KahaDestination().setName("Foo")).setType(KahaDestination.DestinationType.QUEUE));
        expected.setMessage(new Buffer(new byte[]{1, 2, 3, 4, 5, 6}));
        expected.setMessageId("Hello World");
        int size = expected.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
        os.writeByte(expected.type().getNumber());
        expected.writeFramed((OutputStream)os);
        ByteSequence seq = os.toByteSequence();
        DataByteArrayInputStream is = new DataByteArrayInputStream(seq);
        KahaEntryType type = KahaEntryType.valueOf((int)is.readByte());
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed((InputStream)is);
        PBMesssagesTest.assertEquals((Object)expected, (Object)message);
    }
}

