/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.io.File;
import java.lang.reflect.Array;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TestSupport
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSupport.class);
    protected ActiveMQConnectionFactory connectionFactory;
    protected boolean topic = true;

    public TestSupport() {
    }

    public TestSupport(String name) {
        super(name);
    }

    protected ActiveMQMessage createMessage() {
        return new ActiveMQMessage();
    }

    protected Destination createDestination(String subject) {
        if (this.topic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected void assertTextMessagesEqual(Message[] firstSet, Message[] secondSet) throws JMSException {
        this.assertTextMessagesEqual("", firstSet, secondSet);
    }

    protected void assertTextMessagesEqual(String messsage, Message[] firstSet, Message[] secondSet) throws JMSException {
        TestSupport.assertEquals((String)("Message count does not match: " + messsage), (int)firstSet.length, (int)secondSet.length);
        for (int i = 0; i < secondSet.length; ++i) {
            TextMessage m1 = (TextMessage)firstSet[i];
            TextMessage m2 = (TextMessage)secondSet[i];
            this.assertTextMessageEqual("Message " + (i + 1) + " did not match : ", m1, m2);
        }
    }

    protected void assertEquals(TextMessage m1, TextMessage m2) throws JMSException {
        this.assertEquals("", (Message)m1, (Message)m2);
    }

    protected void assertTextMessageEqual(String message, TextMessage m1, TextMessage m2) throws JMSException {
        TestSupport.assertFalse((String)(message + ": expected {" + m1 + "}, but was {" + m2 + "}"), (boolean)(m1 == null ^ m2 == null));
        if (m1 == null) {
            return;
        }
        TestSupport.assertEquals((String)message, (String)m1.getText(), (String)m2.getText());
    }

    protected void assertEquals(Message m1, Message m2) throws JMSException {
        this.assertEquals("", m1, m2);
    }

    protected void assertEquals(String message, Message m1, Message m2) throws JMSException {
        TestSupport.assertFalse((String)(message + ": expected {" + m1 + "}, but was {" + m2 + "}"), (boolean)(m1 == null ^ m2 == null));
        if (m1 == null) {
            return;
        }
        TestSupport.assertTrue((String)(message + ": expected {" + m1 + "}, but was {" + m2 + "}"), (m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        if (m1 instanceof TextMessage) {
            this.assertTextMessageEqual(message, (TextMessage)m1, (TextMessage)m2);
        } else {
            this.assertEquals(message, m1, m2);
        }
    }

    protected void assertBaseDirectoryContainsSpaces() {
        TestSupport.assertFalse((String)"Base directory cannot contain spaces.", (boolean)new File(System.getProperty("basedir", ".")).getAbsoluteFile().toString().contains(" "));
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            TestSupport.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    protected String getConsumerSubject() {
        return this.getSubject();
    }

    protected String getProducerSubject() {
        return this.getSubject();
    }

    protected String getSubject() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected void assertArrayEqual(String message, Object[] expected, Object[] actual) {
        TestSupport.assertEquals((String)(message + ". Array length"), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            TestSupport.assertEquals((String)(message + ". element: " + i), (Object)expected[i], (Object)actual[i]);
        }
    }

    protected void assertPrimitiveArrayEqual(String message, Object expected, Object actual) {
        int length = Array.getLength(expected);
        TestSupport.assertEquals((String)(message + ". Array length"), (int)length, (int)Array.getLength(actual));
        for (int i = 0; i < length; ++i) {
            TestSupport.assertEquals((String)(message + ". element: " + i), (Object)Array.get(expected, i), (Object)Array.get(actual, i));
        }
    }
}

